/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Predicate;
import nolijium.mixinextras.lib.apache.commons.tuple.Pair;
import nolijium.mixinextras.utils.InternalConstructor;
import nolijium.mixinextras.utils.InternalField;
import nolijium.mixinextras.utils.InternalMethod;
import nolijium.mixinextras.wrapper.WrapperInjectionInfo;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionCheckClass;

public class MixinInternals {
    private static final InternalField TARGET_CLASS_CONTEXT_MIXINS = InternalField.of("org.spongepowered.asm.mixin.transformer.TargetClassContext", "mixins");
    private static final InternalMethod MIXIN_INFO_GET_STATE = InternalMethod.of("org.spongepowered.asm.mixin.transformer.MixinInfo", "getState", new Class[0]);
    private static final InternalField STATE_CLASS_NODE = InternalField.of("org.spongepowered.asm.mixin.transformer.MixinInfo$State", "classNode");
    private static final InternalField EXTENSIONS = InternalField.of(Extensions.class, "extensions");
    private static final InternalField ACTIVE_EXTENSIONS = InternalField.of(Extensions.class, "activeExtensions");
    private static final InternalField INJECTION_INFO_TARGET_NODES = InternalField.of(InjectionInfo.class, "targetNodes");
    private static final InternalField INJECTION_NODE_DECORATIONS = InternalField.of(InjectionNodes.InjectionNode.class, "decorations");
    private static final InternalField INJECTION_INFO_INJECTOR = InternalField.of(InjectionInfo.class, "injector");
    private static final InternalMethod CLASS_INFO_FROM_CLASS_NODE = InternalMethod.of(ClassInfo.class, "fromClassNode", ClassNode.class);
    private static final InternalConstructor INJECTOR_ENTRY = InternalConstructor.of("org.spongepowered.asm.mixin.injection.struct.InjectionInfo$InjectorEntry", Class.class, Class.class);
    private static final InternalField INJECTOR_ENTRY_ANNOTATION_TYPE = InternalField.of("org.spongepowered.asm.mixin.injection.struct.InjectionInfo$InjectorEntry", "annotationType");
    private static final InternalField INJECTION_INFO_REGISTRY = InternalField.of(InjectionInfo.class, "registry");
    private static final InternalField INJECTION_INFO_REGISTERED_ANNOTATIONS = InternalField.of(InjectionInfo.class, "registeredAnnotations");

    public static List getMixinsFor(ITargetClassContext object) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        object = ((SortedSet)TARGET_CLASS_CONTEXT_MIXINS.get(object)).iterator();
        while (object.hasNext()) {
            IMixinInfo iMixinInfo;
            IMixinInfo iMixinInfo2 = iMixinInfo = (IMixinInfo)object.next();
            arrayList.add(Pair.of(iMixinInfo2, MixinInternals.getClassNode(iMixinInfo2)));
        }
        return arrayList;
    }

    public static Map getTargets(InjectionInfo injectionInfo) {
        if (injectionInfo instanceof WrapperInjectionInfo) {
            return ((WrapperInjectionInfo)injectionInfo).getTargetMap();
        }
        return (Map)INJECTION_INFO_TARGET_NODES.get(injectionInfo);
    }

    public static Extensions getExtensions() {
        return (Extensions)((IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer()).getExtensions();
    }

    public static void registerExtension(IExtension iExtension) {
        MixinInternals.registerExtension(iExtension, false);
    }

    public static void registerExtension(IExtension iExtension, boolean bl) {
        Extensions extensions = MixinInternals.getExtensions();
        MixinInternals.addExtension((List)EXTENSIONS.get(extensions), iExtension, bl);
        ArrayList arrayList = new ArrayList((Collection)ACTIVE_EXTENSIONS.get(extensions));
        MixinInternals.addExtension(arrayList, iExtension, bl);
        ACTIVE_EXTENSIONS.set(extensions, Collections.unmodifiableList(arrayList));
    }

    public static void unregisterExtension(IExtension iExtension) {
        Extensions extensions = MixinInternals.getExtensions();
        ((List)EXTENSIONS.get(extensions)).remove(iExtension);
        ArrayList arrayList = new ArrayList((Collection)ACTIVE_EXTENSIONS.get(extensions));
        arrayList.remove(iExtension);
        ACTIVE_EXTENSIONS.set(extensions, Collections.unmodifiableList(arrayList));
    }

    private static void addExtension(List list, IExtension iExtension2, boolean bl) {
        if (bl) {
            list.add(0, iExtension2);
        } else {
            list.add(iExtension2);
        }
        MixinInternals.shiftLateExtensions(list, iExtension -> iExtension instanceof ExtensionCheckClass);
    }

    private static void shiftLateExtensions(List list, Predicate predicate) {
        ArrayList<IExtension> arrayList = new ArrayList<IExtension>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            IExtension iExtension = (IExtension)listIterator.next();
            if (!predicate.test(iExtension)) continue;
            listIterator.remove();
            arrayList.add(iExtension);
        }
        list.addAll(arrayList);
    }

    public static Map getDecorations(InjectionNodes.InjectionNode object) {
        if ((object = (Map)INJECTION_NODE_DECORATIONS.get(object)) == null) {
            return Collections.emptyMap();
        }
        return object;
    }

    public static Injector getInjector(InjectionInfo injectionInfo) {
        return (Injector)INJECTION_INFO_INJECTOR.get(injectionInfo);
    }

    private static ClassNode getClassNode(IMixinInfo iMixinInfo) {
        return (ClassNode)STATE_CLASS_NODE.get(MIXIN_INFO_GET_STATE.call(iMixinInfo, new Object[0]));
    }

    public static void registerClassInfo(ClassNode classNode) {
        CLASS_INFO_FROM_CLASS_NODE.call(null, classNode);
    }

    public static void registerInjector(String object, Class object2) {
        try {
            object = Class.forName((String)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Could not find injector annotation, please report to LlamaLad7!", classNotFoundException);
        }
        Map map = (Map)INJECTION_INFO_REGISTRY.get(null);
        object2 = INJECTOR_ENTRY.newInstance(object, object2);
        map.put(Type.getDescriptor((Class)object), object2);
        MixinInternals.bakeInjectionInfoArray(map);
    }

    public static void unregisterInjector(String string) {
        Map map = (Map)INJECTION_INFO_REGISTRY.get(null);
        map.remove("L" + string.replace('.', '/') + ';');
        MixinInternals.bakeInjectionInfoArray(map);
    }

    private static void bakeInjectionInfoArray(Map object) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (Object e2 : object.values()) {
            arrayList.add((Class)INJECTOR_ENTRY_ANNOTATION_TYPE.get(e2));
        }
        INJECTION_INFO_REGISTERED_ANNOTATIONS.set(null, arrayList.toArray(new Class[0]));
    }
}

