/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.obsidianboat.item;

import com.unrealdinnerbone.obsidianboat.OBRegistry;
import com.unrealdinnerbone.obsidianboat.advancements.BoatTrigger;
import com.unrealdinnerbone.obsidianboat.entity.ObsidianBoatEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ObsidianBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);

    public ObsidianBoatItem() {
        super(new Item.Properties().fireResistant().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitResult = ObsidianBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vector3d = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vector3d1 = player.getEyePosition();
            for (Entity entity : list) {
                if (!entity.getBoundingBox().inflate((double)entity.getPickRadius()).contains(vector3d1)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            ObsidianBoatEntity entity = new ObsidianBoatEntity(level, hitResult.getLocation());
            entity.yRotO = player.yRotO;
            entity.setYRot(player.getYRot());
            if (!level.noCollision((Entity)entity, entity.getBoundingBox().inflate(-0.1))) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide) {
                BlockState state;
                level.addFreshEntity((Entity)entity);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitResult.getLocation());
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if ((state = level.getBlockState(BlockPos.containing((Position)hitResult.getLocation()))).is(Blocks.WATER) && player instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)player;
                    ((BoatTrigger)((Object)OBRegistry.BOAT_TRIGGER.get())).trigger(serverplayer);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

