/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.controls;

import com.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.klikli_dev.occultism.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class ItemSlotWidget {
    protected int x;
    protected int y;
    protected int stackSize;
    protected int guiLeft;
    protected int guiTop;
    protected boolean showStackSize;
    protected Minecraft minecraft;
    protected IStorageControllerGuiContainer parent;
    protected ItemStack stack;
    protected Font fontRenderer;
    protected int slotHighlightColor;

    public ItemSlotWidget(IStorageControllerGuiContainer parent, @Nonnull ItemStack stack, int x, int y, int stackSize, int guiLeft, int guiTop, boolean showStackSize) {
        this.x = x;
        this.y = y;
        this.stackSize = stackSize;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.showStackSize = showStackSize;
        this.parent = parent;
        this.minecraft = Minecraft.getInstance();
        this.stack = stack;
        this.fontRenderer = this.parent.getFontRenderer();
        this.slotHighlightColor = new Color(255, 255, 255, 128).getRGB();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean getShowStackSize() {
        return this.showStackSize;
    }

    public void setShowStackSize(boolean showStackSize) {
        this.showStackSize = showStackSize;
    }

    public boolean isMouseOverSlot(int mouseX, int mouseY) {
        return this.parent.isPointInRegionController(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(GuiGraphics guiGraphics, int mx, int my) {
        guiGraphics.pose().pushPose();
        if (!this.getStack().isEmpty()) {
            if (this.showStackSize) {
                String amount = Screen.hasShiftDown() ? Integer.toString(this.stackSize) : TextUtil.formatLargeNumber(this.stackSize);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                guiGraphics.renderItemDecorations(this.fontRenderer, this.stack, this.x * 2 + 16, this.y * 2 + 16, amount);
                guiGraphics.pose().popPose();
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, -100.0f);
            guiGraphics.renderItem(this.getStack(), this.x, this.y);
            guiGraphics.pose().popPose();
            if (this.isMouseOverSlot(mx, my)) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.parent.drawGradientRect(guiGraphics, this.x, this.y, this.x + 16, this.y + 16, this.slotHighlightColor, this.slotHighlightColor);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
        guiGraphics.pose().popPose();
    }

    public void drawTooltip(GuiGraphics guiGraphics, int mx, int my) {
        if (this.isMouseOverSlot(mx, my) && !this.getStack().isEmpty()) {
            this.parent.renderToolTip(guiGraphics, this.getStack(), mx, my);
        }
    }
}

