/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.MummyFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MummyFamiliarModel
extends EntityModel<MummyFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart head;
    public ModelPart leftArm1;
    public ModelPart leftLeg1;
    public ModelPart skeleton;
    public ModelPart spine;
    public ModelPart rightArm1;
    public ModelPart rightLeg1;
    public ModelPart nose;
    public ModelPart eyeSockets;
    public ModelPart leftEye;
    public ModelPart rightEye;
    public ModelPart crown;
    public ModelPart tooth;
    public ModelPart leftArm2;
    public ModelPart leftArmBandage;
    public ModelPart heka;
    public ModelPart leftGlove;
    public ModelPart leftLeg2;
    public ModelPart leftLegBandage;
    public ModelPart rightArm2;
    public ModelPart rightGlove;
    public ModelPart rightArmBandage;
    public ModelPart rightLeg2;
    public ModelPart leftLegBandage_1;

    public MummyFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.head = this.body.getChild("head");
        this.leftArm1 = this.body.getChild("leftArm1");
        this.leftLeg1 = this.body.getChild("leftLeg1");
        this.skeleton = this.body.getChild("skeleton");
        this.spine = this.body.getChild("spine");
        this.rightArm1 = this.body.getChild("rightArm1");
        this.rightLeg1 = this.body.getChild("rightLeg1");
        this.nose = this.head.getChild("nose");
        this.eyeSockets = this.head.getChild("eyeSockets");
        this.leftEye = this.head.getChild("leftEye");
        this.rightEye = this.head.getChild("rightEye");
        this.crown = this.head.getChild("crown");
        this.tooth = this.nose.getChild("tooth");
        this.leftArm2 = this.leftArm1.getChild("leftArm2");
        this.leftArmBandage = this.leftArm1.getChild("leftArmBandage");
        this.heka = this.leftArm2.getChild("heka");
        this.leftGlove = this.leftArm2.getChild("leftGlove");
        this.leftLeg2 = this.leftLeg1.getChild("leftLeg2");
        this.leftLegBandage = this.leftLeg1.getChild("leftLegBandage");
        this.rightArm2 = this.rightArm1.getChild("rightArm2");
        this.rightGlove = this.rightArm2.getChild("rightGlove");
        this.rightArmBandage = this.rightArm2.getChild("rightArmBandage");
        this.rightLeg2 = this.rightLeg1.getChild("rightLeg2");
        this.leftLegBandage_1 = this.rightLeg2.getChild("leftLegBandage_1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -7.0f, -1.5f, 5.0f, 7.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm1 = body.addOrReplaceChild("leftArm1", CubeListBuilder.create().texOffs(44, 0).addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.51f, (float)-7.0f, (float)0.0f, (float)-0.27366763f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg1 = body.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(40, 6).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.49f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition skeleton = body.addOrReplaceChild("skeleton", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, -7.0f, -1.0f, 4.0f, 7.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.01f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(0, 19).addBox(-0.5f, -7.0f, -0.5f, 1.0f, 7.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm1 = body.addOrReplaceChild("rightArm1", CubeListBuilder.create().texOffs(44, 0).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.49f, (float)-7.0f, (float)0.0f, (float)-0.27366763f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg1 = body.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(40, 6).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.51f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(34, 0).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eyeSockets = head.addOrReplaceChild("eyeSockets", CubeListBuilder.create().texOffs(52, 0).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(13, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(13, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition crown = head.addOrReplaceChild("crown", CubeListBuilder.create().texOffs(4, 22).addBox(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-1.5f, (float)-0.07819075f, (float)0.0f, (float)0.0f));
        PartDefinition tooth = nose.addOrReplaceChild("tooth", CubeListBuilder.create().texOffs(0, 31).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.8f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm2 = leftArm1.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(48, 6).addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)3.5f, (float)0.01f, (float)-0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition leftArmBandage = leftArm1.addOrReplaceChild("leftArmBandage", CubeListBuilder.create().texOffs(44, 28).addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)1.6f, (float)1.7f, (float)0.0f, (float)1.7453292E-4f, (float)2.9717722f));
        PartDefinition heka = leftArm2.addOrReplaceChild("heka", CubeListBuilder.create().texOffs(24, 22).addBox(0.0f, -2.0f, -6.0f, 0.0f, 4.0f, 6.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)3.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftGlove = leftArm2.addOrReplaceChild("leftGlove", CubeListBuilder.create().texOffs(36, 26).addBox(-0.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)3.7f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg1.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(40, 11).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)2.5f, (float)0.01f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegBandage = leftLeg1.addOrReplaceChild("leftLegBandage", CubeListBuilder.create().texOffs(44, 28).addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)1.5f, (float)0.0f, (float)0.27366763f, (float)0.1563815f));
        PartDefinition rightArm2 = rightArm1.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(48, 6).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)3.5f, (float)0.01f, (float)-0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition rightGlove = rightArm2.addOrReplaceChild("rightGlove", CubeListBuilder.create().texOffs(36, 26).addBox(-0.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)3.7f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArmBandage = rightArm2.addOrReplaceChild("rightArmBandage", CubeListBuilder.create().texOffs(44, 28).addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-1.0f, (float)2.6f, (float)1.7f, (float)0.039095376f, (float)0.23474678f, (float)2.726379f));
        PartDefinition rightLeg2 = rightLeg1.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(40, 11).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)2.5f, (float)0.01f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegBandage_1 = rightLeg2.addOrReplaceChild("leftLegBandage_1", CubeListBuilder.create().texOffs(44, 28).addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-0.5f, (float)1.9f, (float)1.5f, (float)0.07819075f, (float)-0.039095376f, (float)-1.9957839f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(MummyFamiliarEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.showModels(pEntity);
        this.setRotateAngle(this.body, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.head, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightArm1, -0.274f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightArm2, -0.43f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftArm1, -0.274f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftArm2, -0.43f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightLeg1, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightLeg2, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftLeg1, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftLeg2, 0.0f, 0.0f, 0.0f);
        this.body.z = 0.0f;
        this.head.xRot = this.toRads(pHeadPitch);
        this.head.yRot = this.toRads(pNetHeadYaw);
        this.rightLeg1.xRot = Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * this.toRads(40.0f) * pLimbSwingAmount;
        this.leftLeg1.xRot = Mth.cos((float)(pLimbSwing * 0.5f)) * this.toRads(40.0f) * pLimbSwingAmount;
        this.rightLeg2.xRot = Math.abs(Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI))) * this.toRads(40.0f) * pLimbSwingAmount;
        this.leftLeg2.xRot = Math.abs(Mth.cos((float)(pLimbSwing * 0.5f)) * this.toRads(40.0f)) * pLimbSwingAmount;
        this.rightArm1.xRot = Mth.cos((float)(pLimbSwing * 0.5f)) * this.toRads(40.0f) * pLimbSwingAmount;
        this.leftArm1.xRot = Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * this.toRads(40.0f) * pLimbSwingAmount;
        this.rightArm2.xRot = this.toRads(-30.0f) + Mth.cos((float)(pLimbSwing * 0.5f)) * this.toRads(20.0f) * pLimbSwingAmount;
        this.leftArm2.xRot = this.toRads(-30.0f) + Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * this.toRads(20.0f) * pLimbSwingAmount;
        int fightPose = pEntity.getFightPose();
        if (fightPose == 0) {
            this.body.yRot = this.toRads(-60.0f);
            this.body.xRot = this.toRads(-40.0f);
            this.body.zRot = this.toRads(40.0f);
            this.head.yRot = this.toRads(60.0f);
            this.head.xRot = this.toRads(20.0f);
            this.rightArm1.xRot = this.toRads(20.0f);
            this.rightArm1.zRot = this.toRads(60.0f);
            this.rightArm2.xRot = this.toRads(-20.0f);
            this.leftArm1.xRot = this.toRads(-30.0f);
            this.leftArm1.yRot = this.toRads(40.0f);
            this.leftArm1.zRot = this.toRads(-40.0f);
            this.leftArm2.xRot = this.toRads(-70.0f);
            this.rightLeg1.zRot = this.toRads(70.0f);
            this.leftLeg1.xRot = this.toRads(-20.0f);
            this.leftLeg1.zRot = this.toRads(-60.0f);
            this.leftLeg2.zRot = this.toRads(110.0f);
        } else if (fightPose == 1) {
            this.body.yRot = this.toRads(40.0f);
            this.head.yRot = this.toRads(-25.0f);
            this.leftArm1.xRot = this.toRads(-60.0f);
            this.leftArm1.zRot = this.toRads(-70.0f);
            this.leftArm2.xRot = this.toRads(-10.0f);
            this.rightArm1.yRot = this.toRads(-20.0f);
            this.rightArm1.xRot = this.toRads(30.0f);
            this.rightArm2.xRot = this.toRads(-90.0f);
            this.leftLeg1.yRot = this.toRads(-40.0f);
            this.leftLeg1.xRot = this.toRads(-50.0f);
            this.leftLeg2.xRot = this.toRads(50.0f);
            this.rightLeg1.yRot = this.toRads(60.0f);
            this.rightLeg1.xRot = this.toRads(-40.0f);
            this.rightLeg2.xRot = this.toRads(25.0f);
        } else if (fightPose == 2) {
            this.body.yRot = this.toRads(-60.0f);
            this.head.yRot = this.toRads(60.0f);
            this.head.xRot = this.toRads(-15.0f);
            this.rightArm1.yRot = this.toRads(60.0f);
            this.rightArm1.xRot = this.toRads(-140.0f);
            this.rightArm2.xRot = this.toRads(-35.0f);
            this.leftArm1.yRot = this.toRads(40.0f);
            this.leftArm1.xRot = this.toRads(40.0f);
            this.leftArm2.xRot = this.toRads(-70.0f);
            this.rightLeg1.yRot = this.toRads(60.0f);
            this.rightLeg1.xRot = this.toRads(-40.0f);
            this.rightLeg2.xRot = this.toRads(55.0f);
            this.leftLeg1.yRot = this.toRads(60.0f);
            this.leftLeg1.xRot = this.toRads(30.0f);
        }
        if (pEntity.isPartying()) {
            this.setRotateAngle(this.head, 0.0f, 0.0f, 0.0f);
            float bodyRot = pAgeInTicks * 10.0f % 360.0f;
            this.body.z = Mth.sin((float)this.toRads(bodyRot)) * 5.0f;
            this.body.yRot = bodyRot > 90.0f && bodyRot < 270.0f ? 0.0f : (float)Math.PI;
            this.leftArm1.xRot = this.toRads(90.0f);
            this.leftArm2.xRot = this.toRads(-90.0f) + Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(20.0f);
            this.rightArm1.xRot = this.toRads(-90.0f);
            this.rightArm2.xRot = this.toRads(-90.0f) + Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(20.0f);
            this.leftLeg1.xRot = this.toRads(-20.0f) + Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(20.0f);
            this.leftLeg2.xRot = this.toRads(20.0f) + Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(-10.0f);
            this.rightLeg1.xRot = this.toRads(-20.0f) - Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(20.0f);
            this.rightLeg2.xRot = this.toRads(20.0f) - Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(-10.0f);
        } else if (pEntity.isSitting()) {
            this.head.xRot = this.toRads(40.0f);
            this.head.yRot = this.toRads(-20.0f);
            this.body.xRot = this.toRads(35.0f);
            this.leftArm1.xRot = this.toRads(-50.0f);
            this.leftArm2.xRot = this.toRads(10.0f);
            this.rightArm1.xRot = this.toRads(-50.0f);
            this.rightArm2.xRot = this.toRads(10.0f);
            this.leftLeg1.xRot = this.toRads(-35.0f);
            this.rightLeg1.xRot = this.toRads(-35.0f);
        }
    }

    private float toRads(float deg) {
        return (float)Math.toRadians(deg);
    }

    private void showModels(MummyFamiliarEntity entityIn) {
        boolean hasUpgrade;
        this.leftGlove.visible = hasUpgrade = entityIn.hasBlacksmithUpgrade();
        this.rightGlove.visible = hasUpgrade;
        this.crown.visible = entityIn.hasCrown();
        this.heka.visible = entityIn.hasHeka();
        this.tooth.visible = entityIn.hasTooth();
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

