/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render;

import com.klikli_dev.occultism.client.misc.ClientPentacleManager;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.integration.waila.WailaIntegration;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class GoldenSacrificialBowlHUD
implements LayeredDraw.Layer {
    private static final GoldenSacrificialBowlHUD instance = new GoldenSacrificialBowlHUD();

    public static GoldenSacrificialBowlHUD get() {
        return instance;
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, @NotNull DeltaTracker pDeltaTracker) {
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.getInstance();
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            ClientPentacleManager.reset();
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos pos = blockHitResult.getBlockPos();
        if (mc.level != null && !(mc.level.getBlockEntity(pos) instanceof GoldenSacrificialBowlBlockEntity)) {
            ClientPentacleManager.reset();
            return;
        }
        ClientPentacleManager.rebuild(pos);
        if (!WailaIntegration.displayPentacles() && (blockEntity = mc.level.getBlockEntity(pos)) instanceof GoldenSacrificialBowlBlockEntity) {
            GoldenSacrificialBowlBlockEntity bowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
            Font font = mc.font;
            int x = pGuiGraphics.guiWidth() / 2;
            int y = pGuiGraphics.guiHeight() / 2 + 9;
            PoseStack pose = pGuiGraphics.pose();
            pose.pushPose();
            if (bowl.ritualActive) {
                String ritualID = I18n.get((String)("item.occultism.ritual_dummy." + bowl.getCurrentRitualRecipe().id().getPath().substring(7)), (Object[])new Object[0]);
                String ritualName = Component.translatable((String)ritualID).getString();
                int i = ritualName.indexOf(":");
                pGuiGraphics.drawCenteredString(font, (Component)Component.translatable((String)"occultism.waila.current_ritual", (Object[])new Object[]{Component.literal((String)ritualName.substring(i + 2))}), x, y, (bowl.getSignal() == 8 ? ChatFormatting.GREEN.getColor() : ChatFormatting.GRAY.getColor()).intValue());
                y += 9;
                if (!bowl.sacrificeFulfilled()) {
                    pGuiGraphics.drawCenteredString(font, (Component)Component.translatable((String)"occultism.waila.no_sacrifice"), x, y, ChatFormatting.RED.getColor().intValue());
                    pGuiGraphics.drawCenteredString(font, (Component)Component.translatable((String)((RitualRecipe)bowl.currentRitualRecipe.value()).getEntityToSacrificeDisplayName()), x, y += 9, -1);
                }
                if (!bowl.itemUseFulfilled()) {
                    pGuiGraphics.drawCenteredString(font, (Component)Component.translatable((String)"ritual.occultism.use_item"), x, y, -1);
                    ItemStack[] stacks = ((RitualRecipe)bowl.currentRitualRecipe.value()).getItemToUse().getItems();
                    if (stacks.length > 0) {
                        int index = stacks.length == 1 ? 0 : (int)(System.currentTimeMillis() / 1000L) % stacks.length;
                        pGuiGraphics.drawCenteredString(font, (Component)Component.translatable((String)stacks[index].getDescriptionId()), x, y += 9, -1);
                    }
                }
            } else if (!ClientPentacleManager.lastPentacles.isEmpty()) {
                pGuiGraphics.drawCenteredString(font, (Component)Component.translatable((String)"hud.occultism.pentacle_found"), x, y, ChatFormatting.GOLD.getColor().intValue());
                y += 9;
                for (MutableComponent text : ClientPentacleManager.lastPentacles) {
                    pGuiGraphics.drawCenteredString(font, (Component)text, x, y, -1);
                    y += 9;
                }
            } else {
                pGuiGraphics.drawCenteredString(font, (Component)ClientPentacleManager.noPentacleFound.withStyle(ChatFormatting.YELLOW), x, y, -1);
            }
            pose.popPose();
        }
    }
}

