/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.blockentity;

import com.klikli_dev.occultism.common.block.SpiritAttunedCrystalBlock;
import com.klikli_dev.occultism.common.blockentity.SacrificialBowlBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SacrificialBowlRenderer
implements BlockEntityRenderer<SacrificialBowlBlockEntity> {
    public SacrificialBowlRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static float getScale(ItemStack stack) {
        BlockItem itemBlock;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (itemBlock = (BlockItem)item).getBlock() instanceof SpiritAttunedCrystalBlock) {
            return 3.0f;
        }
        return 1.0f;
    }

    public void render(SacrificialBowlBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        double yOffset;
        double xOffset;
        ItemStackHandler handler = blockEntity.itemStackHandler;
        ItemStack stack = handler.getStackInSlot(0);
        long time = blockEntity.getLevel().getGameTime();
        Direction facing = blockEntity.getBlockState().hasProperty((Property)BlockStateProperties.FACING) ? (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING) : Direction.UP;
        poseStack.pushPose();
        poseStack.pushPose();
        double offset = Math.sin(((float)(time - blockEntity.lastChangeTime) + partialTicks) / 16.0f) * 0.5 + 0.5;
        double fixedOffset = 0.2;
        double d = facing.getAxis() == Direction.Axis.X ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -(offset /= 4.0) - fixedOffset) : (xOffset = 0.0);
        double d2 = facing.getAxis() == Direction.Axis.Y ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -offset - fixedOffset) : (yOffset = 0.0);
        double zOffset = facing.getAxis() == Direction.Axis.Z ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -offset - fixedOffset) : 0.0;
        poseStack.translate(0.5 + xOffset, 0.5 + yOffset, 0.5 + zOffset);
        long systemTime = System.currentTimeMillis();
        float angle = systemTime / 16L % 360L;
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        float scale = SacrificialBowlRenderer.getScale(stack) * 0.5f;
        poseStack.scale(scale, scale, scale);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = itemRenderer.getModel(stack, blockEntity.getLevel(), null, 0);
        itemRenderer.render(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, model);
        poseStack.popPose();
        poseStack.mulPose(facing.getRotation());
        poseStack.popPose();
    }
}

