/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.DeerFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.DeerFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DeerFamiliarRenderer
extends MobRenderer<DeerFamiliarEntity, DeerFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/deer_familiar.png");

    public DeerFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DeerFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_DEER)), 0.3f);
        this.addLayer(new RedNoseLayer((RenderLayerParent<DeerFamiliarEntity, DeerFamiliarModel>)this));
    }

    public void render(DeerFamiliarEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        if (entityIn.isPartying()) {
            matrixStackIn.translate(0.0, 0.08, 0.0);
        } else if (entityIn.isSitting()) {
            matrixStackIn.translate(0.0, -0.38, 0.0);
        }
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(DeerFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class RedNoseLayer
    extends RenderLayer<DeerFamiliarEntity, DeerFamiliarModel> {
        private static final ResourceLocation RED_NOSE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/deer_familiar_red_nose.png");

        public RedNoseLayer(RenderLayerParent<DeerFamiliarEntity, DeerFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, DeerFamiliarEntity deer, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (deer.isInvisible() || !deer.hasRedNose()) {
                return;
            }
            DeerFamiliarModel model = (DeerFamiliarModel)this.getParentModel();
            VertexConsumer ivertexbuilder = pBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)RED_NOSE));
            model.renderToBuffer(pMatrixStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)deer, (float)0.0f));
        }
    }
}

