/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.client.gui.storage.ClientStorageCache;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.klikli_dev.occultism.common.misc.StorageControllerSlot;
import com.klikli_dev.occultism.network.Networking;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public abstract class StorageControllerContainerBase
extends AbstractContainerMenu
implements IStorageControllerContainer {
    public static ConcurrentMap<BlockPos, UUID> openContainers = new ConcurrentHashMap<BlockPos, UUID>();
    public Inventory playerInventory;
    public Player player;
    protected ResultContainer result;
    protected StorageControllerCraftingInventory matrix;
    protected SimpleContainer orderInventory;
    protected RecipeHolder<CraftingRecipe> currentRecipe;
    protected ClientStorageCache clientStorageCache;
    protected boolean recipeLocked = false;

    protected StorageControllerContainerBase(@Nullable MenuType<?> type, int id, Inventory playerInventory) {
        super(type, id);
        this.playerInventory = playerInventory;
        this.player = playerInventory.player;
        this.result = new ResultContainer();
        this.orderInventory = new SimpleContainer(1);
    }

    public static boolean canOpen(Player player, BlockPos pos) {
        if (!openContainers.containsKey(pos) || ((UUID)openContainers.get(pos)).equals(player.getUUID())) {
            return true;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"messages.occultism.container_already_open").withStyle(ChatFormatting.RED));
        return false;
    }

    public static void reserve(Player player, BlockPos pos) {
        openContainers.put(pos, player.getUUID());
    }

    @Override
    public ClientStorageCache getClientStorageCache() {
        return this.clientStorageCache;
    }

    @Override
    public void setClientStorageCache(ClientStorageCache cache) {
        this.clientStorageCache = cache;
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        return GlobalBlockPos.from((BlockEntity)this.getStorageController());
    }

    @Override
    public CraftingContainer getCraftMatrix() {
        return this.matrix;
    }

    public void slotsChanged(Container inventoryIn) {
        if (this.recipeLocked) {
            return;
        }
        this.updateCraftingSlots(false);
        this.broadcastChanges();
        this.findRecipeForMatrix();
    }

    @Override
    public SimpleContainer getOrderSlot() {
        return this.orderInventory;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (player.level().isClientSide) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            IStorageController storageController = this.getStorageController();
            if (index == 0) {
                this.craftShift(player, storageController);
                return ItemStack.EMPTY;
            }
            if (storageController != null) {
                int remainingItems = storageController.insertStack(slotStack, false);
                ItemStack remainingItemStack = remainingItems == 0 ? ItemStack.EMPTY : slotStack.copyWithCount(remainingItems);
                slot.set(remainingItemStack);
                this.broadcastChanges();
                Networking.sendTo((ServerPlayer)player, storageController.getMessageUpdateStacks());
                if (!remainingItemStack.isEmpty()) {
                    slot.onTake(player, slotStack);
                }
                return ItemStack.EMPTY;
            }
        }
        return result;
    }

    public void removed(Player playerIn) {
        this.updateCraftingSlots(false);
        this.updateOrderSlot(true);
        super.removed(playerIn);
        openContainers.values().removeIf(uuid -> uuid.equals(playerIn.getUUID()));
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 61;
        int playerInventoryLeft = 56;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar() {
        int hotbarTop = 119;
        int hotbarLeft = 56;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupCraftingGrid() {
        int craftingGridTop = 0;
        int craftingGridLeft = 85;
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.matrix, index++, craftingGridLeft + j * 18, craftingGridTop + i * 18));
            }
        }
    }

    protected void setupCraftingOutput() {
        int craftingOutputTop = 18;
        int craftingOutputLeft = 178;
        StorageControllerSlot slotCraftOutput = new StorageControllerSlot(this.playerInventory.player, (CraftingContainer)this.matrix, (Container)this.result, this, 0, craftingOutputLeft, craftingOutputTop);
        this.addSlot((Slot)slotCraftOutput);
    }

    protected void setupOrderInventorySlot() {
        int orderSlotTop = 18;
        int orderSlotLeft = 13;
        this.addSlot(new Slot((Container)this.orderInventory, 0, orderSlotLeft, orderSlotTop));
    }

    protected void findRecipeForMatrixClient() {
        Optional optional = this.player.level().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), this.player.level());
        optional.ifPresentOrElse(iCraftingRecipe -> {
            this.currentRecipe = iCraftingRecipe;
        }, () -> {
            this.currentRecipe = null;
        });
    }

    protected void findRecipeForMatrix() {
        if (!this.player.level().isClientSide) {
            this.currentRecipe = null;
            ServerPlayer serverplayerentity = (ServerPlayer)this.player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = this.player.level().getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), this.player.level());
            if (optional.isPresent()) {
                RecipeHolder icraftingrecipe = (RecipeHolder)optional.get();
                if (this.result.setRecipeUsed(this.player.level(), serverplayerentity, icraftingrecipe)) {
                    itemstack = ((CraftingRecipe)icraftingrecipe.value()).assemble((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), (HolderLookup.Provider)serverplayerentity.level().registryAccess());
                    this.currentRecipe = icraftingrecipe;
                }
            }
            this.result.setItem(0, itemstack);
            serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, 0, 0, itemstack));
        }
    }

    protected void craftShift(Player player, IStorageController storageController) {
        ItemStack newResult;
        if (this.matrix == null) {
            return;
        }
        this.findRecipeForMatrixClient();
        if (this.currentRecipe == null) {
            return;
        }
        this.recipeLocked = true;
        ArrayList<ItemStack> recipeCopy = new ArrayList<ItemStack>(this.matrix.getContainerSize());
        for (int i = 0; i < this.matrix.getContainerSize(); ++i) {
            recipeCopy.add(this.matrix.getItem(i).copy());
        }
        ItemStack result = ((CraftingRecipe)this.currentRecipe.value()).assemble((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), (HolderLookup.Provider)player.level().registryAccess());
        if (result.isEmpty()) {
            return;
        }
        int resultStackSize = result.getCount();
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        int crafted = 0;
        while (crafted + resultStackSize <= result.getMaxStackSize() && this.currentRecipe != null && (newResult = ((CraftingRecipe)this.currentRecipe.value()).assemble((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), (HolderLookup.Provider)player.level().registryAccess()).copy()).getItem() == result.getItem() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInventory), (ItemStack)newResult, (boolean)true).isEmpty() && ((CraftingRecipe)this.currentRecipe.value()).matches((RecipeInput)CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems()), player.level())) {
            resultList.add(newResult);
            CraftingInput craftingInput = CraftingInput.of((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems());
            CraftingInput.Positioned positionedCraftingInput = CraftingInput.ofPositioned((int)this.matrix.getWidth(), (int)this.matrix.getHeight(), (List)this.matrix.getItems());
            NonNullList remainingCraftingItems = ((CraftingRecipe)this.currentRecipe.value()).getRemainingItems((RecipeInput)craftingInput);
            int left = positionedCraftingInput.left();
            int top = positionedCraftingInput.top();
            for (int k = 0; k < craftingInput.height(); ++k) {
                for (int l = 0; l < craftingInput.width(); ++l) {
                    int currentSlot = l + left + (k + top) * this.matrix.getWidth();
                    ItemStack currentCraftingItem = (ItemStack)remainingCraftingItems.get(l + k * craftingInput.width());
                    ItemStack stackInSlot = this.matrix.getItem(currentSlot);
                    if (currentCraftingItem.isEmpty()) {
                        this.matrix.getItem(currentSlot).shrink(1);
                        continue;
                    }
                    if (!stackInSlot.getItem().getCraftingRemainingItem(stackInSlot).isEmpty()) {
                        ItemStack container = stackInSlot.getItem().getCraftingRemainingItem(stackInSlot);
                        if (!stackInSlot.isStackable()) {
                            stackInSlot = container;
                            this.matrix.setItem(currentSlot, stackInSlot);
                            continue;
                        }
                        stackInSlot.shrink(1);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)container);
                        continue;
                    }
                    if (!currentCraftingItem.isEmpty()) {
                        if (stackInSlot.isEmpty()) {
                            this.matrix.setItem(currentSlot, currentCraftingItem);
                            continue;
                        }
                        if (!stackInSlot.isDamageableItem() && ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                            this.matrix.setItem(currentSlot, currentCraftingItem);
                            continue;
                        }
                        if (ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                            this.matrix.setItem(currentSlot, currentCraftingItem);
                            continue;
                        }
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newResult);
                        continue;
                    }
                    if (stackInSlot.isEmpty()) continue;
                    this.matrix.removeItem(currentSlot, 1);
                    stackInSlot = this.matrix.getItem(currentSlot);
                }
            }
            crafted += resultStackSize;
            for (int i = 0; i < this.matrix.getContainerSize(); ++i) {
                ItemStack stackInSlot = this.matrix.getItem(i);
                if (!stackInSlot.isEmpty()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackComparator comparator = !recipeStack.isEmpty() ? new ItemStackComparator(recipeStack) : null;
                ItemStack requestedItem = this.getStorageController().getOneOfMostCommonItem(comparator, false);
                this.matrix.setItem(i, requestedItem);
            }
            this.slotsChanged((Container)this.matrix);
        }
        ItemStack finalResult = new ItemStack((ItemLike)result.getItem(), 0);
        finalResult.applyComponents(result.getComponents());
        for (ItemStack intermediateResult : resultList) {
            finalResult.setCount(finalResult.getCount() + intermediateResult.getCount());
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)finalResult);
        this.broadcastChanges();
        this.recipeLocked = false;
        this.slotsChanged((Container)this.matrix);
        Networking.sendTo((ServerPlayer)player, this.getStorageController().getMessageUpdateStacks());
    }

    public boolean hasIngredient(Ingredient ingredient, Object2IntOpenHashMap<Object> reservedAmounts) {
        int reservedAmount;
        for (int i = 1; i < 10; ++i) {
            Slot slot = this.getSlot(i);
            ItemStack stackInSlot = slot.getItem();
            if (stackInSlot.isEmpty() || !ingredient.test(stackInSlot)) continue;
            reservedAmount = reservedAmounts.getOrDefault((Object)slot, 0);
            if (stackInSlot.getCount() <= reservedAmount) continue;
            reservedAmounts.merge((Object)slot, 1, Integer::sum);
            return true;
        }
        ClientStorageCache clientCache = this.getClientStorageCache();
        if (clientCache == null) {
            return false;
        }
        for (ItemStack stack : clientCache.getByIngredient(ingredient)) {
            reservedAmount = reservedAmounts.getOrDefault((Object)stack, 0);
            if (stack.getCount() - reservedAmount < 1) continue;
            reservedAmounts.merge((Object)stack, 1, Integer::sum);
            return true;
        }
        return false;
    }

    public MissingIngredientSlots findMissingIngredients(Map<Integer, Ingredient> ingredients) {
        HashSet<Integer> missingSlots = new HashSet<Integer>();
        HashSet<Integer> craftableSlots = new HashSet<Integer>();
        Object2IntOpenHashMap reservedGridAmounts = new Object2IntOpenHashMap();
        NonNullList playerItems = this.playerInventory.items;
        int[] reservedPlayerItems = new int[playerItems.size()];
        for (Map.Entry<Integer, Ingredient> entry : ingredients.entrySet()) {
            Ingredient ingredient = entry.getValue();
            boolean found = false;
            for (int i = 0; i < playerItems.size(); ++i) {
                ItemStack stack = (ItemStack)playerItems.get(i);
                if (stack.getCount() - reservedPlayerItems[i] <= 0 || !ingredient.test(stack)) continue;
                int n = i;
                reservedPlayerItems[n] = reservedPlayerItems[n] + 1;
                found = true;
                break;
            }
            if (!found && this.hasIngredient(ingredient, (Object2IntOpenHashMap<Object>)reservedGridAmounts)) {
                reservedGridAmounts.merge((Object)ingredient, 1, Integer::sum);
                found = true;
            }
            if (found) continue;
            missingSlots.add(entry.getKey());
        }
        return new MissingIngredientSlots(missingSlots, craftableSlots);
    }

    public record MissingIngredientSlots(Set<Integer> missingSlots, Set<Integer> craftableSlots) {
        public int totalSize() {
            return this.missingSlots.size() + this.craftableSlots.size();
        }

        public boolean anyMissingOrCraftable() {
            return this.anyMissing() || this.anyCraftable();
        }

        public boolean anyMissing() {
            return !this.missingSlots.isEmpty();
        }

        public boolean anyCraftable() {
            return !this.craftableSlots.isEmpty();
        }
    }
}

