/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.common.container.spirit.SpiritTransporterContainer;
import com.klikli_dev.occultism.common.entity.ai.goal.DepositItemsGoal;
import com.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.klikli_dev.occultism.common.entity.ai.goal.ReturnToWorkAreaGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.util.StorageUtil;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class CleanerJob
extends SpiritJob
implements MenuProvider {
    protected PickupItemsGoal pickupItemsGoal;
    protected ReturnToWorkAreaGoal returnToWorkAreaGoal;
    protected DepositItemsGoal depositItemsGoal;

    public CleanerJob(SpiritEntity entity) {
        super(entity);
    }

    public Component getDisplayName() {
        return this.entity.getDisplayName();
    }

    @Override
    public void onInit() {
        this.returnToWorkAreaGoal = new ReturnToWorkAreaGoal(this.entity);
        this.entity.targetSelector.addGoal(0, (Goal)this.returnToWorkAreaGoal);
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.targetSelector.addGoal(1, (Goal)this.pickupItemsGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.goalSelector.addGoal(4, (Goal)this.depositItemsGoal);
    }

    @Override
    public void cleanup() {
        this.entity.targetSelector.removeGoal((Goal)this.returnToWorkAreaGoal);
        this.entity.targetSelector.removeGoal((Goal)this.pickupItemsGoal);
        this.entity.goalSelector.removeGoal((Goal)this.depositItemsGoal);
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.getItem();
        boolean matches = StorageUtil.matchesFilter(stack, (IItemHandler)this.entity.getFilterItems()) || StorageUtil.matchesFilter(stack, this.entity.getTagFilter());
        boolean isBlacklist = this.entity.isFilterBlacklist();
        return !isBlacklist && matches || isBlacklist && !matches;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new SpiritTransporterContainer(id, playerInventory, this.entity);
    }
}

