/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit;

import com.klikli_dev.occultism.common.entity.spirit.WildHuntSkeletonEntity;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class WildHuntWitherSkeletonEntity
extends WitherSkeleton {
    List<WildHuntSkeletonEntity> minions = new ArrayList<WildHuntSkeletonEntity>();

    public WildHuntWitherSkeletonEntity(EntityType<? extends WildHuntWitherSkeletonEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WitherSkeleton.createAttributes().add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MAX_HEALTH, 60.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        int maxSkeletons = 3 + level.getRandom().nextInt(6);
        for (int i = 0; i < maxSkeletons; ++i) {
            WildHuntSkeletonEntity entity = (WildHuntSkeletonEntity)OccultismEntities.WILD_HUNT_SKELETON.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            double offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            double offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
            entity.setMaster(this);
            this.minions.add(entity);
        }
        return super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    protected boolean isSunBurnTick() {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.isInvulnerable()) {
            this.minions.forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, false, false)));
            return true;
        }
        TagKey<EntityType<?>> wildHuntTag = OccultismTags.Entities.WILD_HUNT;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildHuntTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildHuntTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean isInvulnerable() {
        return !this.minions.isEmpty() || super.isInvulnerable();
    }

    public void notifyMinionDeath(WildHuntSkeletonEntity minion) {
        this.minions.remove((Object)minion);
    }
}

