/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.misc;

import com.klikli_dev.occultism.api.common.container.IItemStackComparator;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemTagComparator
implements IItemStackComparator {
    protected TagKey<Item> tag;

    public ItemTagComparator(TagKey<Item> tag) {
        this.tag = tag;
    }

    private ItemTagComparator() {
    }

    public static ItemTagComparator from(CompoundTag nbt, HolderLookup.Provider provider) {
        ItemTagComparator comparator = new ItemTagComparator();
        comparator.deserializeNBT(provider, nbt);
        return comparator;
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.is(this.tag);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.read(nbt);
    }

    public void read(CompoundTag compound) {
        compound.putString("tag", this.tag.location().toString());
    }

    public CompoundTag write(CompoundTag compound) {
        this.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)compound.getString("tag")));
        return compound;
    }
}

