/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class EntityUtil {
    public static Optional<ServerPlayer> getPlayerByUuiDGlobal(UUID uuid) {
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().getAllLevels()) {
            ServerPlayer player = (ServerPlayer)level.getPlayerByUUID(uuid);
            if (player == null) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(UUID uuid) {
        return EntityUtil.getEntityByUuiDGlobal(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel level : server.getAllLevels()) {
                Entity entity = level.getEntity(uuid);
                if (entity == null) continue;
                return Optional.of(entity);
            }
        }
        return Optional.empty();
    }

    public static EntityType<?> entityTypeFromNbt(CompoundTag nbtTagCompound) {
        ResourceLocation typeId = ResourceLocation.parse((String)nbtTagCompound.getString("id"));
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId);
    }

    public static EntityType<?> getEntityInTag(Level level, TagKey<EntityType<?>> tag) {
        List<EntityType> list;
        HolderLookup.RegistryLookup lookup = level.registryAccess().lookupOrThrow(Registries.ENTITY_TYPE);
        HolderSet.Named set = lookup.getOrThrow(tag);
        return list.get((list = set.stream().map(Holder::value).filter(type -> type != EntityType.PLAYER).filter(type -> type.create(level) != null).toList()).size() == 1 ? 0 : (int)(System.currentTimeMillis() / 2880L % (long)list.size()));
    }

    public static void renderEntity(PoseStack matrix, LivingEntity pLivingEntity, MultiBufferSource pBuffer, float partialTicks) {
        matrix.pushPose();
        pLivingEntity.setYRot(0.0f);
        pLivingEntity.yBodyRot = pLivingEntity.getYRot();
        pLivingEntity.yHeadRot = pLivingEntity.getYRot();
        pLivingEntity.yHeadRotO = pLivingEntity.getYRot();
        EntityRenderDispatcher erd = Minecraft.getInstance().getEntityRenderDispatcher();
        erd.setRenderShadow(false);
        erd.render((Entity)pLivingEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrix, pBuffer, 0xF000F0);
        erd.setRenderShadow(true);
        matrix.popPose();
    }
}

