/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public abstract class ItemEnergyFrameInteractionBlockEntity
extends FrameInteractionBlockEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
ExtendedMenuProvider,
ScreenProvider,
MachineAddonController,
RedstoneAddonBlockEntity.RedstoneControllable {
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, this::setChanged);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(this.getInventorySize(), this::setChanged);
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;

    public ItemEnergyFrameInteractionBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract int getMoveEnergyUsage();

    public abstract int getOperationEnergyUsage();

    @Override
    protected boolean canProgress() {
        return !this.disabledViaRedstone && (float)this.energyStorage.amount >= (float)this.getMoveEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed()) && (float)this.energyStorage.amount >= (float)this.getOperationEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed());
    }

    @Override
    protected void doProgress(boolean moving) {
        int usedCost = moving ? this.getMoveEnergyUsage() : this.getOperationEnergyUsage();
        this.energyStorage.amount -= (long)((float)usedCost * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed()));
    }

    @Override
    public void finishBlockWork(BlockPos processed) {
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.energyStorage.amount = nbt.getLong("energy_stored");
        this.disabledViaRedstone = nbt.getBoolean("oritech.redstone");
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        nbt.putBoolean("oritech.redstone", this.disabledViaRedstone);
        this.writeAddonToNbt(nbt);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public BlockPos getPosForAddon() {
        return this.getBlockPos();
    }

    @Override
    public Level getWorldForAddon() {
        return this.getLevel();
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 50, 11));
    }

    public int getInventorySize() {
        return 1;
    }

    @Override
    public float getProgress() {
        float maxTime = this.isMoving() ? this.getMoveTime() : this.getWorkTime();
        return (float)this.getCurrentProgress() / maxTime;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return (float)this.getOperationEnergyUsage() * this.getBaseAddonData().efficiency() * (1.0f / this.getBaseAddonData().speed());
    }

    @Override
    public long getDefaultCapacity() {
        return 100000L;
    }

    @Override
    public long getDefaultInsertRate() {
        return 5000L;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public float getSpeedMultiplier() {
        return this.addonData.speed();
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        return super.getFacing();
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.getEnergyStorage();
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
        this.setChanged();
    }

    public boolean isActivelyWorking() {
        return this.level.getGameTime() - this.lastWorkedAt < 5L;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.heldStacks.size() <= slot) {
            return 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)((float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        return 0;
    }

    @Override
    public int getComparatorActiveState() {
        return this.isActivelyWorking() ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.disabledViaRedstone) {
            return 15;
        }
        return 0;
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.disabledViaRedstone) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled";
    }
}

