/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class PoweredFurnaceBlockEntity
extends MultiblockMachineEntity {
    private final float FURNACE_SPEED_MULTIPLIER;

    public PoweredFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.POWERED_FURNACE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.furnaceData.energyPerTick());
        this.FURNACE_SPEED_MULTIPLIER = Oritech.CONFIG.processingMachines.furnaceData.speedMultiplier();
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.furnaceData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.furnaceData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.ASSEMBLER;
    }

    @Override
    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * this.getEfficiencyMultiplier() * (1.0f / this.getSpeedMultiplier()) / 2.0f;
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state)) {
            return;
        }
        Optional recipeCandidate = world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)this.getFurnaceInput(), world);
        if (recipeCandidate.isPresent() && this.canAddToSlot(((SmeltingRecipe)((RecipeHolder)recipeCandidate.get()).value()).getResultItem((HolderLookup.Provider)world.registryAccess()), (ItemStack)this.inventory.heldStacks.get(1))) {
            if (this.hasEnoughEnergy()) {
                SmeltingRecipe activeRecipe = (SmeltingRecipe)((RecipeHolder)recipeCandidate.get()).value();
                this.useEnergy();
                ++this.progress;
                this.lastWorkedAt = world.getGameTime();
                if ((double)world.random.nextFloat() > 0.8) {
                    ParticleContent.FURNACE_BURNING.spawn(world, Vec3.atLowerCornerOf((Vec3i)pos), (Object)1);
                }
                if (this.furnaceCraftingFinished(activeRecipe)) {
                    this.craftFurnaceItem(activeRecipe);
                    for (int i = 0; i < this.getBaseAddonData().extraChambers() && this.canAddToSlot(((SmeltingRecipe)((RecipeHolder)recipeCandidate.get()).value()).getResultItem((HolderLookup.Provider)world.registryAccess()), (ItemStack)this.inventory.heldStacks.get(1)) && !((ItemStack)this.inventory.heldStacks.get(0)).isEmpty(); ++i) {
                        this.craftFurnaceItem(activeRecipe);
                    }
                    this.resetProgress();
                }
                this.setChanged();
            }
        } else if (this.progress > 0) {
            this.resetProgress();
        }
        this.addBurstTicks();
        if (world.getGameTime() % 18L == 0L) {
            this.updateFurnaceState(state);
        }
    }

    private void updateFurnaceState(BlockState state) {
        Boolean wasLit = (Boolean)state.getValue((Property)BlockStateProperties.LIT);
        boolean isLit = this.isActivelyWorking();
        if (wasLit != isLit) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isLit)));
        }
    }

    private void craftFurnaceItem(SmeltingRecipe activeRecipe) {
        ItemStack result = activeRecipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
        ItemStack outSlot = (ItemStack)this.inventory.heldStacks.get(1);
        ItemStack inSlot = (ItemStack)this.inventory.heldStacks.get(0);
        inSlot.shrink(1);
        if (outSlot.isEmpty()) {
            this.inventory.heldStacks.set(1, (Object)result.copy());
        } else {
            outSlot.grow(result.getCount());
        }
    }

    private boolean furnaceCraftingFinished(SmeltingRecipe activeRecipe) {
        return (float)this.progress >= (float)activeRecipe.getCookingTime() * this.getSpeedMultiplier();
    }

    private SingleRecipeInput getFurnaceInput() {
        return new SingleRecipeInput(this.getInputView().get(0));
    }

    @Override
    public float getProgress() {
        if (this.progress == 0) {
            return 0.0f;
        }
        Optional recipeCandidate = Objects.requireNonNull(this.level).getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)this.getFurnaceInput(), this.level);
        if (recipeCandidate.isPresent()) {
            return (float)this.progress / (float)this.getRecipeDuration();
        }
        return 0.0f;
    }

    @Override
    protected int getRecipeDuration() {
        Optional recipeCandidate = Objects.requireNonNull(this.level).getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)this.getFurnaceInput(), this.level);
        if (recipeCandidate.isPresent()) {
            return (int)((float)((SmeltingRecipe)((RecipeHolder)recipeCandidate.get()).value()).getCookingTime() * this.getSpeedMultiplier());
        }
        return 120;
    }

    @Override
    public float getSpeedMultiplier() {
        return super.getSpeedMultiplier() * this.FURNACE_SPEED_MULTIPLIER;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 117, 38, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.POWERED_FURNACE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0));
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, -1, 0));
    }
}

