/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.storage;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class CreativeStorageBlockEntity
extends ExpandableEnergyStorageBlockEntity
implements ComparatorOutputProvider {
    public CreativeStorageBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.CREATIVE_STORAGE_ENTITY, pos, state);
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of();
    }

    @Override
    public long getDefaultCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getDefaultInsertRate() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getDefaultExtractionRate() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getComparatorOutput() {
        if (this.energyStorage.amount == 0L) {
            return 0;
        }
        return (int)(1.0f + (float)this.energyStorage.amount / (float)this.energyStorage.capacity * 14.0f);
    }

    @Override
    public float getCoreQuality() {
        return 0.0f;
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        this.energyStorage.amount = 0x73333300L;
        super.serverTick(world, pos, state, blockEntity);
    }
}

