/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import rearth.oritech.block.blocks.reactor.ReactorAbsorberBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatPipeBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatVentBlock;
import rearth.oritech.block.blocks.reactor.ReactorRodBlock;
import rearth.oritech.block.entity.reactor.ReactorAbsorberPortEntity;
import rearth.oritech.block.entity.reactor.ReactorControllerBlockEntity;
import rearth.oritech.block.entity.reactor.ReactorFuelPortEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.ReactorScreenHandler;
import rearth.oritech.client.ui.components.ReactorBlockRenderComponent;
import rearth.oritech.client.ui.components.ReactorPreviewContainer;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.TooltipHelper;

public class ReactorScreen
extends BaseOwoHandledScreen<FlowLayout, ReactorScreenHandler> {
    private ArrayList<Tuple<Integer, ReactorBlockRenderComponent>> activeComponents;
    private HashSet<ReactorBlockRenderComponent> activeOverlays;
    private LabelComponent tooltipTitle;
    private FlowLayout tooltipContainer;
    private ReactorBlockRenderComponent selectedBlockOverlay;
    private TextureComponent energyIndicator;
    private LabelComponent productionLabel;
    private LabelComponent hottestLabel;
    private LabelComponent sumHeatLabel;
    private LabelComponent statusLabel;

    public ReactorScreen(ReactorScreenHandler handler, Inventory inventory, net.minecraft.network.chat.Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.tooltipContainer = Containers.verticalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
        this.tooltipContainer.surface(Surface.VANILLA_TRANSLUCENT);
        this.tooltipTitle = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"My title!"));
        this.tooltipContainer.child((Component)this.tooltipTitle.margins(Insets.of((int)6)));
        this.tooltipContainer.zIndex(3000);
        this.tooltipContainer.padding(Insets.of((int)3));
        this.tooltipTitle.zIndex(3001);
        FlowLayout overlay = Containers.horizontalFlow((Sizing)Sizing.fixed((int)340), (Sizing)Sizing.fixed((int)200));
        rootComponent.child((Component)overlay.surface(BasicMachineScreen.ORITECH_PANEL));
        this.addReactorComponentPreview(overlay);
        this.addReactorStats(overlay);
        this.addEnergyBar(overlay);
        this.addReactorStatus(overlay);
        this.addTitle(overlay);
        rootComponent.child((Component)this.tooltipContainer.positioning(Positioning.absolute((int)0, (int)0)));
    }

    private void addReactorStats(FlowLayout overlay) {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fixed((int)141), (Sizing)Sizing.content((int)0));
        this.productionLabel = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"RF Production: %s RF/t", (Object[])new Object[]{"50"}).withStyle(ChatFormatting.WHITE));
        this.sumHeatLabel = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"Heat Production: %s RF/t", (Object[])new Object[]{"50"}).withStyle(ChatFormatting.WHITE));
        this.hottestLabel = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"Hottest Part: %s RF/t", (Object[])new Object[]{"50"}).withStyle(ChatFormatting.WHITE));
        container.child((Component)this.productionLabel.margins(Insets.of((int)4)));
        container.child((Component)this.hottestLabel.margins(Insets.of((int)4)));
        container.child((Component)this.sumHeatLabel.margins(Insets.of((int)4)));
        overlay.child(container.margins(Insets.of((int)8)).surface(Surface.PANEL_INSET).positioning(Positioning.absolute((int)183, (int)16)));
    }

    private void addReactorStatus(FlowLayout overlay) {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fixed((int)95), (Sizing)Sizing.content((int)1));
        this.statusLabel = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"Stable").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        container.child(this.statusLabel.horizontalTextAlignment(HorizontalAlignment.CENTER).horizontalSizing(Sizing.fill()).margins(Insets.of((int)4)));
        overlay.child(container.margins(Insets.of((int)4)).surface(Surface.PANEL_INSET).positioning(Positioning.absolute((int)187, (int)75)));
    }

    private BlockPos getPreviewMax() {
        return ((ReactorScreenHandler)this.menu).reactorEntity.areaMax.atY(((ReactorScreenHandler)this.menu).reactorEntity.areaMin.getY() + 1);
    }

    private void addReactorComponentPreview(FlowLayout overlay) {
        ReactorPreviewContainer holoPreviewContainer = new ReactorPreviewContainer(Sizing.fixed((int)180), Sizing.fixed((int)164), FlowLayout.Algorithm.HORIZONTAL, this::onContainerMouseMove);
        holoPreviewContainer.surface(Surface.PANEL_INSET);
        holoPreviewContainer.margins(Insets.of((int)8));
        BlockPos totalSize = this.getPreviewMax().subtract((Vec3i)((ReactorScreenHandler)this.menu).reactorEntity.areaMin);
        int leftCount = totalSize.getZ();
        int rightCount = totalSize.getX();
        int totalWidth = leftCount + rightCount + 3;
        float middlePercentage = (float)leftCount / (float)totalWidth;
        float xOffset = middlePercentage * 170.0f + 10.0f;
        int size = (int)(170.0f / (float)totalWidth * 2.2f);
        this.activeComponents = new ArrayList();
        this.activeOverlays = new HashSet();
        BlockPos.betweenClosedStream((BlockPos)((ReactorScreenHandler)this.menu).reactorEntity.areaMin, (BlockPos)this.getPreviewMax()).forEach(pos -> {
            BlockState state = ((ReactorScreenHandler)this.menu).world.getBlockState(pos);
            if (state.isAir()) {
                return;
            }
            BlockPos offset = pos.subtract((Vec3i)((ReactorScreenHandler)this.menu).reactorEntity.areaMin);
            float projectedPosX = (float)offset.getX() * 0.43f - (float)offset.getZ() * 0.43f;
            float projectedPosY = (float)offset.getX() * 0.224f + (float)offset.getZ() * 0.224f + (float)offset.getY() * 0.5f;
            int zIndex = offset.getY() - offset.getX() - offset.getZ();
            Component preview = new ReactorBlockRenderComponent(null, ((ReactorScreenHandler)this.menu).world.getBlockEntity(pos), zIndex, pos.immutable()).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)((int)(projectedPosX * (float)size + xOffset)), (int)((int)(-projectedPosY * (float)size) + 100)));
            if (offset.getY() == 1) {
                this.activeComponents.add((Tuple<Integer, ReactorBlockRenderComponent>)new Tuple((Object)(-zIndex), (Object)((ReactorBlockRenderComponent)preview)));
            }
            holoPreviewContainer.child(preview);
            if (state.getBlock() instanceof ReactorRodBlock || state.getBlock() instanceof ReactorHeatPipeBlock) {
                Component heatOverlay = new ReactorBlockRenderComponent(Blocks.AIR.defaultBlockState(), null, (float)zIndex + 0.5f, pos.immutable()).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)((int)(projectedPosX * (float)size + xOffset)), (int)((int)(-projectedPosY * (float)size) + 100)));
                holoPreviewContainer.child(heatOverlay);
                this.activeOverlays.add((ReactorBlockRenderComponent)heatOverlay);
            }
        });
        this.selectedBlockOverlay = (ReactorBlockRenderComponent)new ReactorBlockRenderComponent(Blocks.AIR.defaultBlockState(), null, 10.5f, BlockPos.ZERO).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)0, (int)0));
        holoPreviewContainer.child((Component)this.selectedBlockOverlay);
        this.activeComponents.sort(Comparator.comparingInt(Tuple::getA));
        overlay.child((Component)holoPreviewContainer.positioning(Positioning.absolute((int)0, (int)16)));
    }

    protected void containerTick() {
        super.containerTick();
        if (((ReactorScreenHandler)this.menu).reactorEntity.componentStats.isEmpty()) {
            return;
        }
        for (ReactorBlockRenderComponent overlay : this.activeOverlays) {
            boolean isEmpty;
            ReactorControllerBlockEntity.ComponentStatistics data2 = this.getStatsAtPosition(overlay.pos);
            boolean bl = isEmpty = data2.storedHeat() <= 10;
            if (isEmpty) {
                overlay.state = Blocks.AIR.defaultBlockState();
                continue;
            }
            BlockState res = BlockContent.REACTOR_COLD_INDICATOR_BLOCK.defaultBlockState();
            if (data2.storedHeat() > 1000) {
                res = BlockContent.REACTOR_HOT_INDICATOR_BLOCK.defaultBlockState();
            } else if (data2.storedHeat() > 200) {
                res = BlockContent.REACTOR_MEDIUM_INDICATOR_BLOCK.defaultBlockState();
            }
            overlay.state = res;
        }
        int stackHeight = ((ReactorScreenHandler)this.menu).reactorEntity.areaMax.getY() - ((ReactorScreenHandler)this.menu).reactorEntity.areaMin.getY() - 1;
        int sumProducedEnergy = ((ReactorScreenHandler)this.menu).reactorEntity.componentStats.values().stream().mapToInt(data -> data.receivedPulses() * ReactorControllerBlockEntity.RF_PER_PULSE * stackHeight).sum();
        int sumProducedHeat = ((ReactorScreenHandler)this.menu).reactorEntity.componentStats.values().stream().filter(elem -> elem.receivedPulses() > 0).mapToInt(ReactorControllerBlockEntity.ComponentStatistics::heatChanged).sum();
        int hottestComponent = ((ReactorScreenHandler)this.menu).reactorEntity.componentStats.values().stream().mapToInt(ReactorControllerBlockEntity.ComponentStatistics::storedHeat).max().orElse(0);
        this.productionLabel.text((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.rf_production", (Object[])new Object[]{TooltipHelper.getEnergyText(sumProducedEnergy)}));
        this.hottestLabel.text((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.hottest_part", (Object[])new Object[]{hottestComponent}));
        this.sumHeatLabel.text((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.heat_production", (Object[])new Object[]{sumProducedHeat}));
        boolean isActive = sumProducedEnergy + sumProducedHeat > 0;
        String activeLabel = "idle";
        ChatFormatting color = ChatFormatting.WHITE;
        if (isActive) {
            if (hottestComponent < 100) {
                activeLabel = "stable";
            } else if (hottestComponent < 1200) {
                activeLabel = "heating_up";
                color = ChatFormatting.YELLOW;
            } else if (hottestComponent < 1700) {
                activeLabel = "unstable";
                color = ChatFormatting.RED;
            } else {
                activeLabel = "explosion_imminent";
                color = ChatFormatting.DARK_RED;
            }
        }
        this.statusLabel.text((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)("text.oritech.reactor." + activeLabel)).withStyle(ChatFormatting.BOLD).withStyle(color));
        this.updateEnergyBar();
    }

    private void onContainerMouseMove(int mouseX, int mouseY) {
        int posX = mouseX;
        int posY = mouseY;
        for (Tuple<Integer, ReactorBlockRenderComponent> component : this.activeComponents) {
            boolean hit = ((ReactorBlockRenderComponent)((Object)component.getB())).isInBoundingBox(mouseX, mouseY);
            if (!hit) continue;
            BlockPos pos = ((ReactorBlockRenderComponent)((Object)component.getB())).pos;
            this.addStatsToTooltip(pos, ((ReactorScreenHandler)this.menu).world.getBlockState(pos), this.tooltipContainer);
            posX = ((ReactorBlockRenderComponent)((Object)component.getB())).x();
            posY = ((ReactorBlockRenderComponent)((Object)component.getB())).y();
            this.selectedBlockOverlay.state = BlockContent.ADDON_INDICATOR_BLOCK.defaultBlockState();
            this.selectedBlockOverlay.pos = pos;
            this.selectedBlockOverlay.zIndex = ((ReactorBlockRenderComponent)((Object)component.getB())).zIndex + 0.6f;
            this.selectedBlockOverlay.positioning((Positioning)((ReactorBlockRenderComponent)((Object)component.getB())).positioning().get());
            break;
        }
        if (posX == mouseX) {
            this.tooltipContainer.positioning(Positioning.absolute((int)-100, (int)-500));
            this.selectedBlockOverlay.state = Blocks.AIR.defaultBlockState();
            return;
        }
        int containerHeight = this.tooltipContainer.height();
        this.tooltipContainer.positioning(Positioning.absolute((int)(posX - 30), (int)(posY - 5 - containerHeight)));
    }

    public void addStatsToTooltip(BlockPos pos, BlockState state, FlowLayout container) {
        container.clearChildren();
        MutableComponent blockname = state.getBlock().getName();
        container.child((Component)Components.label((net.minecraft.network.chat.Component)blockname.withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})).margins(Insets.of((int)0, (int)3, (int)0, (int)0)));
        ReactorControllerBlockEntity.ComponentStatistics stats = this.getStatsAtPosition(pos);
        if (stats.storedHeat() == -1) {
            return;
        }
        int stackHeight = ((ReactorScreenHandler)this.menu).reactorEntity.areaMax.getY() - ((ReactorScreenHandler)this.menu).reactorEntity.areaMin.getY() - 1;
        BlockPos portPosition = pos.offset(0, stackHeight, 0);
        BlockEntity portEntity = ((ReactorScreenHandler)this.menu).world.getBlockEntity(portPosition);
        if (portEntity != null && portEntity.isRemoved()) {
            return;
        }
        Block block = state.getBlock();
        if (block instanceof ReactorRodBlock) {
            ReactorRodBlock rodBlock = (ReactorRodBlock)block;
            int rodCount = rodBlock.getRodCount();
            short totalPulses = stats.receivedPulses();
            int createdPulses = rodBlock.getInternalPulseCount();
            int externalPulses = totalPulses - createdPulses;
            int generatedEnergy = ReactorControllerBlockEntity.RF_PER_PULSE * totalPulses;
            short generatedHeat = stats.heatChanged();
            int heat = stats.storedHeat();
            if (totalPulses == 0) {
                createdPulses = 0;
                externalPulses = 0;
            }
            if (!(portEntity instanceof ReactorFuelPortEntity)) {
                return;
            }
            ReactorFuelPortEntity fuelPortEntity = (ReactorFuelPortEntity)portEntity;
            int availableFuel = fuelPortEntity.availableFuel;
            int maxFuel = fuelPortEntity.currentFuelOriginalCapacity;
            container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.rod_count", (Object[])new Object[]{rodCount}).withStyle(ChatFormatting.WHITE)));
            container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.generated_pulses", (Object[])new Object[]{createdPulses}).withStyle(ChatFormatting.WHITE)));
            container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.received_pulses", (Object[])new Object[]{externalPulses}).withStyle(ChatFormatting.WHITE)));
            container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.generated_heat", (Object[])new Object[]{generatedHeat}).withStyle(ChatFormatting.WHITE)));
            container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.generated_energy", (Object[])new Object[]{generatedEnergy}).withStyle(ChatFormatting.WHITE)));
            container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.heat", (Object[])new Object[]{heat}).withStyle(ChatFormatting.WHITE)));
            container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.fuel", (Object[])new Object[]{availableFuel, maxFuel}).withStyle(ChatFormatting.WHITE)));
        } else {
            Block rodCount = state.getBlock();
            if (rodCount instanceof ReactorHeatPipeBlock) {
                ReactorHeatPipeBlock pipeBlock = (ReactorHeatPipeBlock)rodCount;
                container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.collected_heat", (Object[])new Object[]{stats.heatChanged()}).withStyle(ChatFormatting.WHITE)));
                container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.heat", (Object[])new Object[]{stats.storedHeat()}).withStyle(ChatFormatting.WHITE)));
            } else {
                rodCount = state.getBlock();
                if (rodCount instanceof ReactorHeatVentBlock) {
                    ReactorHeatVentBlock pipeBlock = (ReactorHeatVentBlock)rodCount;
                    container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.removed_heat", (Object[])new Object[]{stats.heatChanged()}).withStyle(ChatFormatting.WHITE)));
                } else {
                    rodCount = state.getBlock();
                    if (rodCount instanceof ReactorAbsorberBlock) {
                        ReactorAbsorberBlock absorberBlock = (ReactorAbsorberBlock)rodCount;
                        if (!(portEntity instanceof ReactorAbsorberPortEntity)) {
                            return;
                        }
                        ReactorAbsorberPortEntity absorberPortEntity = (ReactorAbsorberPortEntity)portEntity;
                        int availableFuel = absorberPortEntity.availableFuel;
                        int maxFuel = absorberPortEntity.currentFuelOriginalCapacity;
                        container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.absorbed_heat", (Object[])new Object[]{stats.heatChanged()}).withStyle(ChatFormatting.WHITE)));
                        container.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.reactor.absorbant", (Object[])new Object[]{availableFuel, maxFuel}).withStyle(ChatFormatting.WHITE)));
                    }
                }
            }
        }
    }

    public ReactorControllerBlockEntity.ComponentStatistics getStatsAtPosition(BlockPos pos) {
        if (((ReactorScreenHandler)this.menu).reactorEntity.componentStats.isEmpty()) {
            return ReactorControllerBlockEntity.ComponentStatistics.EMPTY;
        }
        BlockPos reactorMin = ((ReactorScreenHandler)this.menu).reactorEntity.areaMin;
        for (Map.Entry<Vector2i, ReactorControllerBlockEntity.ComponentStatistics> entry : ((ReactorScreenHandler)this.menu).reactorEntity.componentStats.entrySet()) {
            Vector2i localPos = entry.getKey();
            BlockPos worldPos = reactorMin.offset(localPos.x + 1, 1, localPos.y + 1);
            if (!worldPos.equals((Object)pos)) continue;
            return entry.getValue();
        }
        return ReactorControllerBlockEntity.ComponentStatistics.EMPTY;
    }

    private void addTitle(FlowLayout overlay) {
        MutableComponent blockTitle = ((ReactorScreenHandler)this.menu).reactorEntity.getBlockState().getBlock().getName();
        LabelComponent label = Components.label((net.minecraft.network.chat.Component)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child((Component)label.positioning(Positioning.relative((int)50, (int)3)));
    }

    private void addEnergyBar(FlowLayout panel) {
        ScreenProvider.BarConfiguration config = new ScreenProvider.BarConfiguration(295, 80, 36, 108);
        int insetSize = 1;
        MutableComponent tooltipText = net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{10, 50});
        FlowLayout frame = Containers.horizontalFlow((Sizing)Sizing.fixed((int)(config.width() + insetSize * 2)), (Sizing)Sizing.fixed((int)(config.height() + insetSize * 2)));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of((int)insetSize));
        frame.positioning(Positioning.absolute((int)(config.x() - insetSize), (int)(config.y() - insetSize)));
        panel.child((Component)frame);
        TextureComponent indicator_background = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)24, (int)0, (int)24, (int)96, (int)98, (int)96);
        indicator_background.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)0, (int)0, (int)24, (int)96, (int)98, (int)96);
        this.energyIndicator.sizing(Sizing.fixed((int)config.width()), Sizing.fixed((int)config.height()));
        this.energyIndicator.positioning(Positioning.absolute((int)0, (int)0));
        this.energyIndicator.tooltip((net.minecraft.network.chat.Component)tooltipText);
        frame.child((Component)indicator_background).child((Component)this.energyIndicator);
    }

    protected void updateEnergyBar() {
        long capacity = ((ReactorScreenHandler)this.menu).reactorEntity.energyStorage.getCapacity();
        long amount = ((ReactorScreenHandler)this.menu).reactorEntity.energyStorage.getAmount();
        float fillAmount = (float)amount / (float)capacity;
        net.minecraft.network.chat.Component tooltipText = BasicMachineScreen.getEnergyTooltip(amount, capacity, 0L, 0L);
        this.energyIndicator.tooltip(tooltipText);
        this.energyIndicator.visibleArea(PositionedRectangle.of((int)0, (int)(96 - (int)(96.0f * fillAmount)), (int)24, (int)((int)(96.0f * fillAmount))));
    }
}

