/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ext;

import java.util.Objects;
import java.util.Set;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DerivedComponentMap
implements DataComponentMap {
    private final DataComponentMap base;
    private final PatchedDataComponentMap delegate;

    public DerivedComponentMap(DataComponentMap base) {
        this.base = base;
        this.delegate = new PatchedDataComponentMap(base);
    }

    public static DataComponentMap reWrapIfNeeded(DataComponentMap original) {
        if (original instanceof DerivedComponentMap) {
            DerivedComponentMap derived = (DerivedComponentMap)original;
            return new DerivedComponentMap(derived.base);
        }
        return original;
    }

    public void derive(ItemStack owner) {
        this.delegate.restorePatch(DataComponentPatch.EMPTY);
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        owner.getItem().deriveStackComponents(owner.getComponents(), builder);
        this.delegate.restorePatch(builder.build());
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> type) {
        return (T)this.delegate.get(type);
    }

    public Set<DataComponentType<?>> keySet() {
        return this.delegate.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DerivedComponentMap) {
            DerivedComponentMap thatDerived = (DerivedComponentMap)o;
            return Objects.equals(this.base, thatDerived.base);
        }
        if (o instanceof DataComponentMap.Builder.SimpleMap) {
            DataComponentMap.Builder.SimpleMap simpleComponentMap = (DataComponentMap.Builder.SimpleMap)o;
            return Objects.equals(this.base, simpleComponentMap);
        }
        return o == EMPTY && this.base == EMPTY;
    }

    public int hashCode() {
        return Objects.hashCode(this.base);
    }
}

