/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.api.blocks;

import com.mojang.datafixers.util.Pair;
import com.pigdad.paganbless.api.blocks.RotatableEntityBlock;
import com.pigdad.paganbless.api.io.IOActions;
import com.pigdad.paganbless.api.io.SidedItemHandler;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerBlockEntity
extends BlockEntity {
    private ItemStackHandler itemHandler;
    private FluidTank fluidTank;

    public ContainerBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public void drop() {
        SimpleContainer inventory = new SimpleContainer(this.getItemHandlerStacks());
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemStack[] getItemHandlerStacks() {
        ItemStack[] itemStacks = new ItemStack[this.itemHandler.getSlots()];
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            itemStacks[i] = this.itemHandler.getStackInSlot(i);
        }
        return itemStacks;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    protected final void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.getFluidTank() != null) {
            this.getFluidTank().writeToNBT(provider, tag);
        }
        if (this.getItemHandler() != null) {
            tag.put("itemhandler", (Tag)this.getItemHandler().serializeNBT(provider));
        }
        this.saveData(tag);
    }

    public final void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (this.getFluidTank() != null) {
            this.getFluidTank().readFromNBT(provider, tag);
        }
        if (this.getItemHandler() != null) {
            this.getItemHandler().deserializeNBT(provider, tag.getCompound("itemhandler"));
        }
        this.loadData(tag);
    }

    protected void loadData(CompoundTag tag) {
    }

    protected void saveData(CompoundTag tag) {
    }

    protected final void addItemHandler(int slots) {
        this.addItemHandler(slots, (slot, itemStack) -> true);
    }

    protected final void addFluidTank(int capacityInMb) {
        this.addFluidTank(capacityInMb, fluidStack -> true);
    }

    public abstract Map<Direction, Pair<IOActions, int[]>> getItemIO();

    public abstract Map<Direction, Pair<IOActions, int[]>> getFluidIO();

    public IItemHandlerModifiable getItemHandlerOnSide(Direction direction) {
        if (direction == null) {
            return this.itemHandler;
        }
        Map<Direction, Pair<IOActions, int[]>> ioPorts = this.getItemIO();
        if (ioPorts.containsKey(direction)) {
            if (direction == Direction.UP || direction == Direction.DOWN) {
                return new SidedItemHandler((IItemHandlerModifiable)this.itemHandler, ioPorts.get(direction));
            }
            if (!this.getBlockState().hasProperty((Property)RotatableEntityBlock.FACING)) {
                return null;
            }
            Direction localDir = (Direction)this.getBlockState().getValue((Property)RotatableEntityBlock.FACING);
            return switch (localDir) {
                case Direction.NORTH -> new SidedItemHandler((IItemHandlerModifiable)this.itemHandler, ioPorts.get(direction.getOpposite()));
                case Direction.EAST -> new SidedItemHandler((IItemHandlerModifiable)this.itemHandler, ioPorts.get(direction.getClockWise()));
                case Direction.SOUTH -> new SidedItemHandler((IItemHandlerModifiable)this.itemHandler, ioPorts.get(direction));
                case Direction.WEST -> new SidedItemHandler((IItemHandlerModifiable)this.itemHandler, ioPorts.get(direction.getCounterClockWise()));
                default -> null;
            };
        }
        return null;
    }

    protected final void addItemHandler(int slots, final ValidationFunctions.ItemValid validation) {
        this.itemHandler = new ItemStackHandler(slots){

            protected void onContentsChanged(int slot) {
                ContainerBlockEntity.this.setChanged();
                ContainerBlockEntity.this.onItemsChanged(slot);
                ContainerBlockEntity.this.update();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return validation.itemValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    private void update() {
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected final void addFluidTank(int capacityInMb, final ValidationFunctions.FluidValid validation) {
        this.fluidTank = new FluidTank(capacityInMb){

            protected void onContentsChanged() {
                ContainerBlockEntity.this.setChanged();
                ContainerBlockEntity.this.onFluidsChanged();
                ContainerBlockEntity.this.update();
            }

            public boolean isFluidValid(FluidStack stack) {
                return validation.fluidValid(stack);
            }
        };
    }

    protected void onItemsChanged(int slot) {
    }

    protected void onFluidsChanged() {
    }

    public void tick() {
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
    }

    public static final class ValidationFunctions {

        @FunctionalInterface
        public static interface FluidValid {
            public boolean fluidValid(FluidStack var1);
        }

        @FunctionalInterface
        public static interface ItemValid {
            public boolean itemValid(int var1, ItemStack var2);
        }
    }
}

