/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blockentities;

import com.mojang.datafixers.util.Pair;
import com.pigdad.paganbless.api.blocks.ContainerBlockEntity;
import com.pigdad.paganbless.api.io.IOActions;
import com.pigdad.paganbless.content.recipes.ImbuingCauldronRecipe;
import com.pigdad.paganbless.registries.PBBlockEntities;
import com.pigdad.paganbless.utils.Utils;
import com.pigdad.paganbless.utils.recipes.PBFluidRecipeInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.joml.Vector3f;

public class ImbuingCauldronBlockEntity
extends ContainerBlockEntity {
    private static final int OUTPUT = 5;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 78;
    public float independentAngle;
    public float chasingVelocity;
    public int inUse;
    public int speed;

    public ImbuingCauldronBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(PBBlockEntities.IMBUING_CAULDRON.get(), blockPos, blockState);
        this.addFluidTank(2000);
        this.addItemHandler(6);
        this.speed = 0;
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> ImbuingCauldronBlockEntity.this.progress;
                    case 1 -> ImbuingCauldronBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        ImbuingCauldronBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        ImbuingCauldronBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void turn() {
        this.inUse = 10;
        this.speed = 1200;
    }

    public Map<Integer, ItemStack> getRenderStack() {
        HashMap<Integer, ItemStack> toReturn = new HashMap<Integer, ItemStack>();
        ItemStackHandler handler = this.getItemHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemStack = handler.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            toReturn.put(i, itemStack);
        }
        return toReturn;
    }

    public boolean isActive() {
        return this.progress > 0;
    }

    public static int getCapacity() {
        return 2000;
    }

    public void clientTick() {
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.getFluidTank().getFluidAmount() >= 1000 && this.getFluidTank().getFluid().is((Fluid)Fluids.WATER)) {
                Utils.spawnParticles((LevelAccessor)this.level, new Vector3f((float)this.worldPosition.getX(), (float)this.worldPosition.getY() + 0.35f, (float)this.worldPosition.getZ()), 1, 0.07f, 0.0, true, (ParticleOptions)ParticleTypes.BUBBLE);
            }
            if (this.inUse == 0) {
                this.speed = 0;
            }
        }
    }

    public void serverTick() {
        if (this.hasRecipe()) {
            ImbuingCauldronBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private float getSpeed() {
        return this.speed;
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        ItemStackHandler itemHandler = this.getItemHandler();
        Optional<RecipeHolder<ImbuingCauldronRecipe>> recipe = this.getCurrentRecipe();
        ItemStack result = ((ImbuingCauldronRecipe)recipe.get().value()).getResultItem(null);
        block0: for (SizedIngredient ingredient : ((ImbuingCauldronRecipe)recipe.get().value()).getIngredientsWithCount()) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!ingredient.test(stack)) continue;
                itemHandler.extractItem(i, ingredient.count(), false);
                continue block0;
            }
        }
        Optional<SizedFluidIngredient> sizedFluidIngredient = ((ImbuingCauldronRecipe)recipe.get().value()).fluidIngredient();
        if (sizedFluidIngredient.isPresent()) {
            this.getFluidTank().drain(sizedFluidIngredient.get().amount(), IFluidHandler.FluidAction.EXECUTE);
        }
        itemHandler.setStackInSlot(5, new ItemStack((ItemLike)result.getItem(), itemHandler.getStackInSlot(5).getCount() + result.getCount()));
    }

    public boolean hasRecipe() {
        Optional<RecipeHolder<ImbuingCauldronRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((ImbuingCauldronRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        boolean itemIntoOutputSlot = this.canInsertItemIntoOutputSlot(result);
        boolean amountIntoOutputSlot = this.canInsertAmountIntoOutputSlot(result);
        return amountIntoOutputSlot && itemIntoOutputSlot;
    }

    private Optional<RecipeHolder<ImbuingCauldronRecipe>> getCurrentRecipe() {
        ItemStackHandler stackHandler = this.getItemHandler();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(stackHandler.getSlots());
        for (int i = 0; i < stackHandler.getSlots() - 1; ++i) {
            itemStacks.add(stackHandler.getStackInSlot(i));
        }
        PBFluidRecipeInput recipeInput = new PBFluidRecipeInput(itemStacks, this.getFluidTank().getFluid());
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ImbuingCauldronRecipe.Type.INSTANCE, (RecipeInput)recipeInput, this.level);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack itemStack) {
        return this.getItemHandler().getStackInSlot(5).isEmpty() || this.getItemHandler().getStackInSlot(5).is(itemStack.getItem());
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack itemStack) {
        return this.getItemHandler().getStackInSlot(5).getCount() + itemStack.getCount() <= itemStack.getMaxStackSize();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    @Override
    protected void saveData(CompoundTag pTag) {
        pTag.putInt("imbuing_cauldron_progress", this.progress);
    }

    @Override
    public Map<Direction, Pair<IOActions, int[]>> getItemIO() {
        return Map.of(Direction.UP, Pair.of((Object)((Object)IOActions.INSERT), (Object)new int[]{0, 1, 2, 3, 4}), Direction.DOWN, Pair.of((Object)((Object)IOActions.EXTRACT), (Object)new int[]{5}));
    }

    @Override
    public Map<Direction, Pair<IOActions, int[]>> getFluidIO() {
        return Map.of();
    }

    @Override
    public void loadData(CompoundTag pTag) {
        this.progress = pTag.getInt("imbuing_cauldron_progress");
    }
}

