/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blockentities;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.pigdad.paganbless.PBConfig;
import com.pigdad.paganbless.api.blocks.ContainerBlockEntity;
import com.pigdad.paganbless.api.io.IOActions;
import com.pigdad.paganbless.content.blocks.RuneSlabBlock;
import com.pigdad.paganbless.content.blocks.RunicCoreBlock;
import com.pigdad.paganbless.content.entities.GoToRunicCoreActivity;
import com.pigdad.paganbless.content.items.CaptureSacrificeItem;
import com.pigdad.paganbless.content.recipes.RunicRitualRecipe;
import com.pigdad.paganbless.networking.RunicCoreRecipePayload;
import com.pigdad.paganbless.registries.PBActivities;
import com.pigdad.paganbless.registries.PBBlockEntities;
import com.pigdad.paganbless.registries.PBMemoryModuleTypes;
import com.pigdad.paganbless.utils.NbtUtils;
import com.pigdad.paganbless.utils.RunicCoreUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.Unit;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class RunicCoreBlockEntity
extends ContainerBlockEntity {
    public static final int RITUAL_TIME = PBConfig.ritualTime;
    private Set<BlockPos> runeSlabs;
    private EntityType<?> entityType;
    private boolean runRecipe;
    private int timer;

    public RunicCoreBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(PBBlockEntities.RUNIC_CORE.get(), p_155229_, p_155230_);
        this.addItemHandler(1, (slot, stack) -> false);
        this.runeSlabs = new HashSet<BlockPos>();
    }

    public void commonTick() {
        if (this.runRecipe) {
            if (RITUAL_TIME == 0) {
                this.performRecipe();
            }
            if (this.timer < RITUAL_TIME) {
                ++this.timer;
            } else {
                this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.85f, 0.5f);
                this.performRecipe();
                this.timer = 0;
            }
        }
    }

    private void makeEntitiesAttracted() {
        List entities = this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.worldPosition).inflate(3.0));
        for (LivingEntity entity : entities) {
            Brain brain = entity.getBrain();
            brain.addActivity((Activity)PBActivities.GO_TO_RUNIC_CORE_ACTIVITY.get(), 5, ImmutableList.of((Object)((Object)new GoToRunicCoreActivity())));
            brain.getMemories().put((MemoryModuleType)PBMemoryModuleTypes.IS_GOING_TO_RC.get(), Optional.empty());
            brain.setMemory((MemoryModuleType)PBMemoryModuleTypes.IS_GOING_TO_RC.get(), (Object)Unit.INSTANCE);
            brain.setActiveActivityIfPossible((Activity)PBActivities.GO_TO_RUNIC_CORE_ACTIVITY.get());
        }
    }

    public void setRunRecipe(boolean run) {
        this.runRecipe = run;
    }

    public void setRuneSlabs(List<BlockPos> runeSlabs) {
        this.runeSlabs = new HashSet<BlockPos>(runeSlabs);
    }

    public void clientTick() {
        if (((Boolean)this.getBlockState().getValue((Property)RunicCoreBlock.ACTIVE)).booleanValue()) {
            Vec3 northPos = new Vec3((double)this.worldPosition.getX() + 0.75, (double)this.worldPosition.getY() + 0.65, (double)this.worldPosition.getZ() + 0.23);
            Vec3 eastPos = new Vec3((double)this.worldPosition.getX() + 0.75, (double)this.worldPosition.getY() + 0.65, (double)this.worldPosition.getZ() + 0.75);
            Vec3 southPos = new Vec3((double)this.worldPosition.getX() + 0.23, (double)this.worldPosition.getY() + 0.65, (double)this.worldPosition.getZ() + 0.75);
            Vec3 westPos = new Vec3((double)this.worldPosition.getX() + 0.23, (double)this.worldPosition.getY() + 0.65, (double)this.worldPosition.getZ() + 0.23);
            Vec3 pos = switch ((Direction)this.getBlockState().getValue((Property)RunicCoreBlock.FACING)) {
                case Direction.NORTH -> northPos;
                case Direction.EAST -> eastPos;
                case Direction.SOUTH -> southPos;
                case Direction.WEST -> westPos;
                default -> null;
            };
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
        if (this.runRecipe) {
            for (BlockPos blockPos : this.runeSlabs) {
                this.renderRuneSlabParticles(blockPos);
            }
            this.renderCenterParticles();
        }
    }

    private void renderRuneSlabParticles(BlockPos blockPos) {
        RuneSlabBlock runeSlabBlock;
        int color;
        BlockPos renderPos = blockPos.above(2);
        Block block = this.level.getBlockState(blockPos).getBlock();
        if (block instanceof RuneSlabBlock && (color = (runeSlabBlock = (RuneSlabBlock)block).getColor()) != 0) {
            this.level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)255, (int)color)), (double)((float)renderPos.getX() + 0.5f), (double)renderPos.getY(), (double)((float)renderPos.getZ() + 0.5f), 0.0, 0.0, 0.0);
            this.level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)255, (int)color)), (double)((float)renderPos.getX() + 0.5f), (double)(renderPos.getY() + 1), (double)((float)renderPos.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    private void renderCenterParticles() {
        int count = this.timer / PBConfig.ritualTime;
        if ((double)count > 0.5) {
            ParticleUtils.spawnParticles((LevelAccessor)this.level, (BlockPos)this.worldPosition.above(), (int)10, (double)0.35, (double)0.35, (boolean)true, (ParticleOptions)ParticleTypes.LARGE_SMOKE);
        }
    }

    public void craftItem(Entity sacrificedEntity) {
        List players = this.level.getNearbyPlayers(TargetingConditions.forNonCombat(), null, new AABB(this.worldPosition).inflate(5.0));
        Optional runes = RunicCoreUtils.tryGetRunePositions(this.level, this.getBlockPos()).left();
        if (runes.isPresent()) {
            this.runeSlabs = (Set)runes.get();
            this.runRecipe = true;
            this.entityType = sacrificedEntity.getType();
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new RunicCoreRecipePayload(this.worldPosition, true, this.runeSlabs.stream().toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, (Holder)SoundEvents.AMBIENT_CAVE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, (Holder)SoundEvents.AMBIENT_CAVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            for (Player player : players) {
                player.sendSystemMessage((Component)RunicCoreUtils.tryGetRunePositions(this.level, this.getBlockPos()).right().get());
            }
        }
    }

    private void performRecipe() {
        List players = this.level.getNearbyPlayers(TargetingConditions.forNonCombat(), null, new AABB(this.worldPosition).inflate(5.0));
        Item runeBlock = this.level.getBlockState((BlockPos)this.runeSlabs.stream().toList().get(0)).getBlock().asItem();
        Optional<Object> recipe = Optional.empty();
        for (RecipeHolder<RunicRitualRecipe> recipe1 : RunicCoreBlockEntity.getAllRitualRecipes(this.level.getRecipeManager())) {
            if (!((RunicRitualRecipe)recipe1.value()).matchesRunes(runeBlock, this.level)) continue;
            recipe = Optional.of((RunicRitualRecipe)recipe1.value());
            break;
        }
        if (recipe.isPresent() && runeBlock != Items.AIR) {
            if (((RunicRitualRecipe)recipe.get()).matchesRunes(runeBlock, this.level)) {
                if (((Boolean)this.getBlockState().getValue((Property)RunicCoreBlock.ACTIVE)).booleanValue()) {
                    ItemStackHandler stackHandler;
                    ItemStack stackInSlot;
                    ItemStack result = ((RunicRitualRecipe)recipe.get()).result().copy();
                    Item item = result.getItem();
                    if (item instanceof CaptureSacrificeItem) {
                        CaptureSacrificeItem captureSacrificeItem = (CaptureSacrificeItem)item;
                        captureSacrificeItem.setEntity(this.entityType, result);
                    }
                    if ((stackInSlot = (stackHandler = this.getItemHandler()).getStackInSlot(0)).isEmpty() || stackInSlot.is(result.getItem()) && stackInSlot.getCount() < stackInSlot.getMaxStackSize()) {
                        stackHandler.setStackInSlot(0, result);
                    } else {
                        Containers.dropItemStack((Level)this.level, (double)((double)this.worldPosition.getX() + 0.5), (double)((double)this.worldPosition.getY() + 0.5), (double)((double)this.worldPosition.getZ() + 0.5), (ItemStack)stackInSlot);
                        stackHandler.setStackInSlot(0, result);
                    }
                    RunicCoreUtils.resetPillars(this.level, this.runeSlabs);
                } else {
                    for (Player player : players) {
                        player.sendSystemMessage((Component)Component.literal((String)"Runic core is not activated, do so with a black thorn staff"));
                    }
                }
            } else {
                for (Player player : players) {
                    player.sendSystemMessage((Component)Component.literal((String)"Rune layout does not match any recipes"));
                }
            }
        }
        this.runRecipe = false;
    }

    public static List<RecipeHolder<RunicRitualRecipe>> getAllRitualRecipes(RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor((RecipeType)RunicRitualRecipe.Type.INSTANCE);
    }

    @Override
    protected void saveData(CompoundTag tag) {
        super.saveData(tag);
        if (this.entityType != null) {
            tag.putString("entity_type", BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType).toString());
        }
        tag.putBoolean("run_recipe", this.runRecipe);
        NbtUtils.saveBlockPosSet(tag, "rune_slabs", this.runeSlabs);
        tag.putInt("timer", this.timer);
    }

    @Override
    protected void loadData(CompoundTag tag) {
        super.loadData(tag);
        Optional entityType = EntityType.byString((String)tag.getString("entity_type"));
        entityType.ifPresent(type -> {
            this.entityType = type;
        });
        this.runRecipe = tag.getBoolean("run_recipe");
        this.runeSlabs = NbtUtils.loadBlockPosSet(tag, "rune_slabs");
        this.timer = tag.getInt("timer");
    }

    @Override
    public Map<Direction, Pair<IOActions, int[]>> getItemIO() {
        return Map.of(Direction.DOWN, Pair.of((Object)((Object)IOActions.EXTRACT), (Object)new int[]{0}));
    }

    @Override
    public Map<Direction, Pair<IOActions, int[]>> getFluidIO() {
        return Map.of();
    }
}

