/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.api.blocks.RotatableEntityBlock;
import com.pigdad.paganbless.api.blocks.TranslucentHighlightFix;
import com.pigdad.paganbless.content.blockentities.JarBlockEntity;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarBlock
extends RotatableEntityBlock
implements TranslucentHighlightFix {
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)5.0, (double)11.5, (double)5.0, (double)11.0, (double)13.5, (double)11.0), Block.box((double)5.0, (double)9.5, (double)5.0, (double)11.0, (double)10.5, (double)11.0), Block.box((double)4.5, (double)10.5, (double)4.5, (double)11.5, (double)12.5, (double)11.5), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.5, (double)12.0)).reduce(Shapes::or).get();

    public JarBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void spawnDestroyParticles(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState) {
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return JarBlock.simpleCodec(JarBlock::new);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new JarBlockEntity(blockPos, blockState);
    }

    @Override
    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        JarBlockEntity jarBlockEntity = (JarBlockEntity)pLevel.getBlockEntity(pPos);
        ItemStackHandler handler = jarBlockEntity.getItemHandler();
        ItemStack itemInHand = pPlayer.getItemInHand(pHand);
        ItemStack stackInSlot = handler.getStackInSlot(0);
        if (itemInHand.isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)stackInSlot.copyAndClear());
            jarBlockEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
        } else {
            ItemStack stack = handler.insertItem(0, itemInHand.copy(), false);
            itemInHand.setCount(pPlayer.hasInfiniteMaterials() ? itemInHand.getCount() : stack.getCount());
            jarBlockEntity.wobble(DecoratedPotBlockEntity.WobbleStyle.POSITIVE);
            if (!stack.isEmpty()) {
                pLevel.playSound(null, pPos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        Object object = pParams.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof JarBlockEntity) {
            JarBlockEntity jarBlockEntity = (JarBlockEntity)((Object)object);
            ItemStack stack = new ItemStack((ItemLike)this);
            jarBlockEntity.saveToItem(stack, (HolderLookup.Provider)pParams.getLevel().registryAccess());
            return List.of(stack);
        }
        return super.getDrops(pState, pParams);
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof JarBlockEntity) {
            JarBlockEntity jarBlockEntity = (JarBlockEntity)blockEntity;
            jarBlockEntity.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
        }
        return stack;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{ROTATION}));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return state != null ? (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)pContext.getRotation()))) : null;
    }
}

