/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.pigdad.paganbless.content.blocks.BaseHangingHerbBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaxedHangingHerbBlock
extends BaseHangingHerbBlock {
    public static final int MAX_HANGING_AMOUNT = 4;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty HANGING_AMOUNT = IntegerProperty.create((String)"hanging_amount", (int)1, (int)4);
    public static final VoxelShape SHAPE_2_NS = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)16.0, (double)12.0);
    public static final VoxelShape SHAPE_3_NS = Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    public static final VoxelShape SHAPE_4_NS = Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    public static final VoxelShape SHAPE_2_EW = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)16.0, (double)13.0);
    public static final VoxelShape SHAPE_3_EW = Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE_4_EW = Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);

    public WaxedHangingHerbBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH) {
            return switch ((Integer)pState.getValue((Property)HANGING_AMOUNT)) {
                case 2 -> SHAPE_2_NS;
                case 3 -> SHAPE_3_NS;
                case 4 -> SHAPE_4_NS;
                default -> SHAPE;
            };
        }
        return switch ((Integer)pState.getValue((Property)HANGING_AMOUNT)) {
            case 2 -> SHAPE_2_EW;
            case 3 -> SHAPE_3_EW;
            case 4 -> SHAPE_4_EW;
            default -> SHAPE;
        };
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int amount = (Integer)state.getValue((Property)HANGING_AMOUNT);
        if (Block.byItem((Item)stack.getItem()) == this) {
            if (amount < 4) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HANGING_AMOUNT, (Comparable)Integer.valueOf(amount + 1)));
                level.playSound(player, pos, SoundEvents.BAMBOO_SAPLING_PLACE, SoundSource.BLOCKS);
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        } else if (stack.isEmpty() && amount > 1) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HANGING_AMOUNT, (Comparable)Integer.valueOf(amount - 1)));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.asItem().getDefaultInstance());
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue((Property)FACING, (Comparable)context.getPlayer().getDirection()) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{HANGING_AMOUNT, FACING}));
    }
}

