/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.pigdad.paganbless.PBConfig;
import com.pigdad.paganbless.data.saved_data.WicanWardSavedData;
import com.pigdad.paganbless.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WicanWardBlock
extends Block {
    public static final int RANGE = PBConfig.wwRange;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape NORTH_SOUTH_SHAPE = Block.box((double)0.0, (double)11.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final VoxelShape EAST_WEST_SHAPE = Block.box((double)7.0, (double)11.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public WicanWardBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getPlayer().getDirection();
        BlockPos blockPos = ctx.getClickedPos().relative(direction);
        BlockState blockState = ctx.getLevel().getBlockState(blockPos);
        if (blockState.is((Block)this)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)blockState.getValue((Property)FACING)));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> EAST_WEST_SHAPE;
            default -> NORTH_SOUTH_SHAPE;
        };
    }

    protected void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            WicanWardSavedData savedData = Utils.getWWData(serverLevel);
            savedData.addBlockPos(pPos);
        }
    }

    protected void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            WicanWardSavedData savedData = Utils.getWWData(serverLevel);
            savedData.removeBlockPos(pPos);
        }
    }
}

