/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.items;

import com.pigdad.paganbless.PBConfig;
import com.pigdad.paganbless.content.blocks.EssenceLogBlock;
import com.pigdad.paganbless.content.blocks.HerbPlantBlock;
import com.pigdad.paganbless.registries.PBItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class BolineItem
extends SwordItem {
    public BolineItem(Item.Properties pProperties) {
        super((Tier)Tiers.STONE, pProperties.attributes(BolineItem.createAttributes((Tier)Tiers.STONE, (int)4, (float)-2.6f)));
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (pAttacker instanceof Player && pTarget instanceof Skeleton && pTarget.getHealth() == 0.0f) {
            RandomSource randomSource = pTarget.getRandom();
            int i = randomSource.nextInt(0, 100 / PBConfig.skeletonSkullFromBolineChance);
            System.out.println(i);
            if (i == 0) {
                BlockPos onPos = pTarget.getOnPos();
                Containers.dropItemStack((Level)pTarget.level(), (double)onPos.getX(), (double)onPos.getY(), (double)onPos.getZ(), (ItemStack)Items.SKELETON_SKULL.getDefaultInstance());
            }
        }
        return super.hurtEnemy(pStack, pTarget, pAttacker);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        Player player = pContext.getPlayer();
        BlockPos blockPos = pContext.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            if (cropBlock.isMaxAge(blockState)) {
                this.dropCropDrops(level, player, blockPos, blockState);
                level.setBlockAndUpdate(blockPos, cropBlock.getStateForAge(0));
                pContext.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pContext.getHand()));
                return InteractionResult.SUCCESS;
            }
        } else {
            block = blockState.getBlock();
            if (block instanceof NetherWartBlock) {
                NetherWartBlock wartBlock = (NetherWartBlock)block;
                if ((Integer)blockState.getValue((Property)NetherWartBlock.AGE) >= 3) {
                    this.dropCropDrops(level, player, blockPos, blockState);
                    level.setBlockAndUpdate(blockPos, wartBlock.defaultBlockState());
                    pContext.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pContext.getHand()));
                    return InteractionResult.SUCCESS;
                }
            } else {
                block = blockState.getBlock();
                if (block instanceof HerbPlantBlock) {
                    HerbPlantBlock herbPlantBlock = (HerbPlantBlock)block;
                    if ((Integer)blockState.getValue((Property)HerbPlantBlock.AGE) >= 5) {
                        this.dropCropDrops(level, player, blockPos, blockState);
                        level.setBlockAndUpdate(blockPos, (BlockState)herbPlantBlock.defaultBlockState().setValue((Property)HerbPlantBlock.AGE, (Comparable)Integer.valueOf(0)));
                        pContext.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pContext.getHand()));
                        return InteractionResult.SUCCESS;
                    }
                } else if (blockState.getBlock() instanceof EssenceLogBlock && ((Boolean)blockState.getValue((Property)EssenceLogBlock.ESSENCE)).booleanValue()) {
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)EssenceLogBlock.ESSENCE, (Comparable)Boolean.valueOf(false)));
                    level.playSound(null, blockPos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.5f);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)PBItems.ESSENCE_OF_THE_FOREST.get(), level.random.nextInt(1, 3)));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    private void dropCropDrops(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)blockPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        for (ItemStack drop : drops) {
            if (drop.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)((double)blockPos.getX() + 0.5), (double)((double)blockPos.getY() + 0.5), (double)((double)blockPos.getZ() + 0.5), (ItemStack)drop);
        }
        level.destroyBlock(blockPos, false, (Entity)player);
    }
}

