/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.items;

import com.pigdad.paganbless.content.blockentities.RuneSlabBlockEntity;
import com.pigdad.paganbless.content.blocks.RuneSlabBlock;
import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.registries.PBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class RunicChargeItem
extends Item {
    public RunicChargeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.is(PBBlocks.RUNE_SLAB_INERT.get())) {
            RuneSlabBlock.RuneState runeState = (RuneSlabBlock.RuneState)((Object)blockState.getValue(RuneSlabBlock.RUNE_STATE));
            BlockEntity blockEntity = (Boolean)blockState.getValue((Property)RuneSlabBlock.IS_TOP) != false ? level.getBlockEntity(blockPos.below()) : level.getBlockEntity(blockPos);
            RuneSlabBlockEntity runeSlabBlockEntity = (RuneSlabBlockEntity)blockEntity;
            String prevBlock = runeSlabBlockEntity.getPrevBlock();
            if (prevBlock != null) {
                ResourceLocation defaultStateLocation = ResourceLocation.parse((String)prevBlock);
                BlockState defaultState = ((Block)BuiltInRegistries.BLOCK.get(defaultStateLocation)).defaultBlockState();
                if (defaultState.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                if (!defaultState.is(PBTags.BlockTags.RUNIC_CHARGE_NO_REFILL)) {
                    Player player = ctx.getPlayer();
                    if (((Boolean)blockState.getValue((Property)RuneSlabBlock.IS_TOP)).booleanValue()) {
                        level.setBlockAndUpdate(blockPos, (BlockState)((BlockState)defaultState.setValue((Property)RuneSlabBlock.IS_TOP, (Comparable)Boolean.valueOf(true))).setValue(RuneSlabBlock.RUNE_STATE, (Comparable)((Object)runeState)));
                        level.setBlockAndUpdate(blockPos.below(), (BlockState)((BlockState)defaultState.setValue((Property)RuneSlabBlock.IS_TOP, (Comparable)Boolean.valueOf(false))).setValue(RuneSlabBlock.RUNE_STATE, (Comparable)((Object)runeState)));
                    } else {
                        level.setBlockAndUpdate(blockPos.above(), (BlockState)((BlockState)defaultState.setValue((Property)RuneSlabBlock.IS_TOP, (Comparable)Boolean.valueOf(true))).setValue(RuneSlabBlock.RUNE_STATE, (Comparable)((Object)runeState)));
                        level.setBlockAndUpdate(blockPos, (BlockState)((BlockState)defaultState.setValue((Property)RuneSlabBlock.IS_TOP, (Comparable)Boolean.valueOf(false))).setValue(RuneSlabBlock.RUNE_STATE, (Comparable)((Object)runeState)));
                    }
                    level.playSound(null, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.isCreative()) {
                        player.getItemInHand(ctx.getHand()).shrink(1);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance());
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }
}

