/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pigdad.paganbless.utils.recipes.PBRecipeInput;
import com.pigdad.paganbless.utils.recipes.RecipeUtils;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record BenchCuttingRecipe(SizedIngredient ingredient, int cuts, boolean tryDamage, Ingredient toolItem, ItemStack resultStack) implements Recipe<PBRecipeInput>
{
    public static final String NAME = "bench_cutting";

    public boolean matches(PBRecipeInput pbRecipeInput, Level level) {
        return this.ingredient.test(pbRecipeInput.getItem(0)) && this.toolItem.test(pbRecipeInput.getItem(1));
    }

    public ItemStack assemble(PBRecipeInput pbRecipeInput, HolderLookup.Provider provider) {
        return this.resultStack.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.resultStack.copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return RecipeUtils.listToNonNullList(RecipeUtils.iWCToIngredients((List<SizedIngredient>)NonNullList.of((Object)this.ingredient, (Object[])new SizedIngredient[0])));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<BenchCuttingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<BenchCuttingRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedIngredient.FLAT_CODEC.fieldOf("ingredient").forGetter(BenchCuttingRecipe::ingredient), (App)ExtraCodecs.POSITIVE_INT.fieldOf("cuts").forGetter(BenchCuttingRecipe::cuts), (App)Codec.BOOL.fieldOf("try_damage").forGetter(BenchCuttingRecipe::tryDamage), (App)Ingredient.CODEC_NONEMPTY.fieldOf("tool").forGetter(BenchCuttingRecipe::toolItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(BenchCuttingRecipe::resultStack)).apply((Applicative)builder, BenchCuttingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, BenchCuttingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC, BenchCuttingRecipe::ingredient, (StreamCodec)ByteBufCodecs.INT, BenchCuttingRecipe::cuts, (StreamCodec)ByteBufCodecs.BOOL, BenchCuttingRecipe::tryDamage, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, BenchCuttingRecipe::toolItem, (StreamCodec)ItemStack.STREAM_CODEC, BenchCuttingRecipe::resultStack, BenchCuttingRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<BenchCuttingRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BenchCuttingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<BenchCuttingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return BenchCuttingRecipe.NAME;
        }
    }
}

