/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.data.saved_data;

import com.pigdad.paganbless.api.data.LocationsSavedData;
import com.pigdad.paganbless.content.blocks.WicanWardBlock;
import com.pigdad.paganbless.utils.DistanceUtils;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class WicanWardSavedData
extends LocationsSavedData {
    public static final String DATA_ID = "wicanward";
    private int tickCounter;

    public WicanWardSavedData() {
    }

    @Override
    public String getDataId() {
        return DATA_ID;
    }

    public WicanWardSavedData(Set<BlockPos> wicanWards) {
        this.blocks = wicanWards;
    }

    public boolean shouldPreventEntitySpawn(BlockPos pos) {
        for (BlockPos wwPos : this.blocks) {
            if (!DistanceUtils.CUBIC.isPositionInRange(pos.getX(), pos.getY(), pos.getZ(), wwPos, WicanWardBlock.RANGE)) continue;
            return true;
        }
        return false;
    }

    public void onGlobalTick(Level level) {
        if (this.tickCounter++ < 200) {
            return;
        }
        this.tickCounter = 0;
        this.blocks.removeIf(wwPos -> this.cleanupCheck(level, (BlockPos)wwPos));
    }

    private boolean cleanupCheck(Level level, BlockPos wwPos) {
        return level.isLoaded(wwPos) && !(level.getBlockState(wwPos).getBlock() instanceof WicanWardBlock);
    }

    private static WicanWardSavedData load(CompoundTag nbt, ServerLevel level) {
        return new WicanWardSavedData(LocationsSavedData.load(nbt, DATA_ID, level));
    }

    public static SavedData.Factory<WicanWardSavedData> factory(ServerLevel pLevel) {
        return new SavedData.Factory(WicanWardSavedData::new, (tag, provider) -> WicanWardSavedData.load(tag, pLevel));
    }
}

