/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.datagen;

import com.pigdad.paganbless.datagen.PBLootTableProvider;
import com.pigdad.paganbless.datagen.PBRecipeProvider;
import com.pigdad.paganbless.datagen.PBTagProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="paganbless", bus=EventBusSubscriber.Bus.MOD)
public class PBDataGenerator {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new PBRecipeProvider(packOutput, lookupProvider));
        PBTagProvider.BlocksProvider blockTagsProvider = new PBTagProvider.BlocksProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeClient(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new PBTagProvider.ItemsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(PBLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

