/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.datagen;

import com.pigdad.paganbless.content.items.PentacleItem;
import com.pigdad.paganbless.datagen.recipe_builder.AnvilSmashingRecipeBuilder;
import com.pigdad.paganbless.datagen.recipe_builder.BenchCuttingRecipeBuilder;
import com.pigdad.paganbless.datagen.recipe_builder.ImbuingCauldronRecipeBuilder;
import com.pigdad.paganbless.datagen.recipe_builder.RunicRitualRecipeBuilder;
import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.registries.PBItems;
import com.pigdad.paganbless.registries.PBTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class PBRecipeProvider
extends RecipeProvider {
    public PBRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        PBRecipeProvider.blackThornWoodRecipes(recipeOutput);
        this.otherRecipes(recipeOutput);
        this.imbuingCauldronRecipes(recipeOutput);
        this.runicRitualRecipes(recipeOutput);
        this.anvilSmashingRecipes(recipeOutput);
        this.benchCuttingRecipes(recipeOutput);
    }

    private void benchCuttingRecipes(RecipeOutput recipeOutput) {
        BenchCuttingRecipeBuilder.newRecipe(new ItemStack((ItemLike)PBItems.BLACK_THORN_STICK.get(), 3), SizedIngredient.of((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_LOG.get()), (int)1), Ingredient.of((TagKey)ItemTags.AXES), 5, true).save(recipeOutput);
        BenchCuttingRecipeBuilder.newRecipe(new ItemStack((ItemLike)PBItems.CHOPPED_RUE.get()), SizedIngredient.of((ItemLike)((ItemLike)PBBlocks.DRIED_HANGING_RUE.get()), (int)1), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PBItems.BOLINE.get()}), 3, true).save(recipeOutput);
        BenchCuttingRecipeBuilder.newRecipe(new ItemStack((ItemLike)PBItems.CHOPPED_LAVENDER.get()), SizedIngredient.of((ItemLike)((ItemLike)PBBlocks.DRIED_HANGING_LAVENDER.get()), (int)1), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PBItems.BOLINE.get()}), 3, true).save(recipeOutput);
        BenchCuttingRecipeBuilder.newRecipe(new ItemStack((ItemLike)PBBlocks.EMPTY_INCENSE.get()), SizedIngredient.of((ItemLike)Items.SKELETON_SKULL, (int)1), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PBItems.BOLINE.get()}), 9, true).save(recipeOutput);
    }

    private void anvilSmashingRecipes(RecipeOutput recipeOutput) {
        AnvilSmashingRecipeBuilder.newRecipe(new ItemStack((ItemLike)Items.REDSTONE, 15), SizedIngredient.of(PBTags.ItemTags.GEMS_CINNABAR, (int)4)).save(recipeOutput);
        AnvilSmashingRecipeBuilder.newRecipe(PBBlocks.RUNIC_CORE.get().asItem().getDefaultInstance(), SizedIngredient.of((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_LOG.get()), (int)1), SizedIngredient.of((ItemLike)Items.SKELETON_SKULL, (int)1), SizedIngredient.of((TagKey)ItemTags.CANDLES, (int)3)).save(recipeOutput);
        AnvilSmashingRecipeBuilder.newRecipe(PBItems.MECHANICAL_COMPONENT.get().getDefaultInstance(), SizedIngredient.of((ItemLike)((ItemLike)PBItems.ESSENCE_OF_THE_FOREST.get()), (int)1), SizedIngredient.of((TagKey)Tags.Items.INGOTS_IRON, (int)2), SizedIngredient.of((ItemLike)((ItemLike)PBItems.BLACK_THORN_STICK.get()), (int)2)).save(recipeOutput);
        this.runeSlabRecipe(recipeOutput, PBBlocks.RUNE_SLAB_CINNABAR.get(), PBTags.ItemTags.GEMS_CINNABAR, 2);
        this.runeSlabRecipe(recipeOutput, PBBlocks.RUNE_SLAB_DIAMOND.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 1);
        this.runeSlabRecipe(recipeOutput, PBBlocks.RUNE_SLAB_EMERALD.get(), (TagKey<Item>)Tags.Items.GEMS_EMERALD, 1);
        this.runeSlabRecipe(recipeOutput, PBBlocks.RUNE_SLAB_LAPIS.get(), (TagKey<Item>)Tags.Items.GEMS_LAPIS, 5);
        this.runeSlabRecipe(recipeOutput, PBBlocks.RUNE_SLAB_QUARTZ.get(), (TagKey<Item>)Tags.Items.GEMS_QUARTZ, 3);
        this.runeSlabRecipe(recipeOutput, PBBlocks.RUNE_SLAB_AMETHYST.get(), (TagKey<Item>)Tags.Items.GEMS_AMETHYST, 2);
    }

    private void runeSlabRecipe(RecipeOutput recipeOutput, Block runeSlabBlock, TagKey<Item> gemItem, int gemCount) {
        AnvilSmashingRecipeBuilder.newRecipe(runeSlabBlock.asItem().getDefaultInstance(), SizedIngredient.of(gemItem, (int)gemCount), SizedIngredient.of((ItemLike)((ItemLike)PBBlocks.RUNE_SLAB_INERT.get()), (int)1)).save(recipeOutput);
    }

    private void runicRitualRecipes(RecipeOutput recipeOutput) {
        RunicRitualRecipeBuilder.newRecipe(PentacleItem.getPentacleDefaultStack(), PBBlocks.RUNE_SLAB_CINNABAR.get()).save(recipeOutput);
        RunicRitualRecipeBuilder.newRecipe(PBItems.WICAN_WARD.get().getDefaultInstance(), PBBlocks.RUNE_SLAB_AMETHYST.get()).save(recipeOutput);
        RunicRitualRecipeBuilder.newRecipe(PBItems.ATHAME.get().getDefaultInstance(), PBBlocks.RUNE_SLAB_DIAMOND.get()).save(recipeOutput);
        RunicRitualRecipeBuilder.newRecipe(PBItems.WAND.get().getDefaultInstance(), PBBlocks.RUNE_SLAB_EMERALD.get()).save(recipeOutput);
        RunicRitualRecipeBuilder.newRecipe(PBItems.ETERNAL_SNOWBALL.get().getDefaultInstance(), PBBlocks.RUNE_SLAB_QUARTZ.get()).save(recipeOutput);
        RunicRitualRecipeBuilder.newRecipe(PBItems.CHALICE.get().getDefaultInstance(), PBBlocks.RUNE_SLAB_LAPIS.get()).save(recipeOutput);
    }

    private void imbuingCauldronRecipes(RecipeOutput recipeOutput) {
        ImbuingCauldronRecipeBuilder.newRecipe(new ItemStack((ItemLike)PBItems.GLAZED_BERRIES.get(), 2)).ingredients(new ItemStack((ItemLike)PBItems.WINTER_BERRIES.get(), 2), new ItemStack((ItemLike)Items.SUGAR, 3)).save(recipeOutput);
        ImbuingCauldronRecipeBuilder.newRecipe(new ItemStack((ItemLike)PBBlocks.RUNE_SLAB_INERT.get()), SizedFluidIngredient.of((TagKey)FluidTags.LAVA, (int)1000)).ingredients(SizedIngredient.of((TagKey)Tags.Items.COBBLESTONES_DEEPSLATE, (int)3)).ingredients(SizedIngredient.of(PBTags.ItemTags.HERBS, (int)2)).save(recipeOutput);
        ImbuingCauldronRecipeBuilder.newRecipe(new ItemStack((ItemLike)PBItems.RUNIC_CHARGE.get()), SizedFluidIngredient.of((TagKey)FluidTags.WATER, (int)500)).ingredients(new ItemLike[]{Items.GLASS_BOTTLE}).ingredients(SizedIngredient.of(PBTags.ItemTags.HERBS, (int)2)).ingredients(SizedIngredient.of((TagKey)Tags.Items.GEMS_AMETHYST, (int)1)).ingredients(SizedIngredient.of((ItemLike)((ItemLike)PBItems.CINNABAR.get()), (int)1)).ingredients(SizedIngredient.of((ItemLike)((ItemLike)PBItems.ESSENCE_OF_THE_FOREST.get()), (int)2)).save(recipeOutput);
    }

    private void otherRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)PBBlocks.IMBUING_CAULDRON.get())).pattern("#S#").pattern("###").define(Character.valueOf('S'), (ItemLike)PBItems.BLACK_THORN_STICK.get()).define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).unlockedBy("has_iron_ingot", PBRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)PBBlocks.HERBALIST_BENCH.get())).pattern("P J").pattern("###").pattern("###").define(Character.valueOf('J'), (ItemLike)PBBlocks.JAR.get()).define(Character.valueOf('P'), (ItemLike)PBBlocks.BLACK_THORN_PRESSURE_PLATE.get()).define(Character.valueOf('#'), Tags.Items.COBBLESTONES_DEEPSLATE).unlockedBy("has_iron_ingot", PBRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)PBBlocks.CRANK.get())).pattern("  S").pattern("###").pattern("M  ").define(Character.valueOf('M'), (ItemLike)PBItems.MECHANICAL_COMPONENT.get()).define(Character.valueOf('S'), (ItemLike)PBItems.BLACK_THORN_STICK.get()).define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).unlockedBy("has_black_thorn_stick", PBRecipeProvider.has((ItemLike)((ItemLike)PBItems.BLACK_THORN_STICK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)PBBlocks.WINCH.get())).pattern("#M#").pattern("#S#").pattern("###").define(Character.valueOf('M'), (ItemLike)PBItems.MECHANICAL_COMPONENT.get()).define(Character.valueOf('S'), (ItemLike)PBItems.BLACK_THORN_STICK.get()).define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).unlockedBy("has_black_thorn_stick", PBRecipeProvider.has((ItemLike)((ItemLike)PBItems.BLACK_THORN_STICK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)PBBlocks.JAR.get())).pattern("#L#").pattern("# #").pattern("###").define(Character.valueOf('L'), (ItemLike)PBBlocks.BLACK_THORN_LOG.get()).define(Character.valueOf('#'), Tags.Items.GLASS_PANES).unlockedBy("has_black_thorn_log", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_LOG.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)PBItems.BLACK_THORN_STAFF.get())).pattern("  #").pattern(" S ").pattern("S  ").define(Character.valueOf('S'), (ItemLike)PBItems.BLACK_THORN_STICK.get()).define(Character.valueOf('#'), (ItemLike)PBItems.ESSENCE_OF_THE_FOREST.get()).unlockedBy("has_black_thorn_stick", PBRecipeProvider.has((ItemLike)((ItemLike)PBItems.BLACK_THORN_STICK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.ROPE.get()), (int)2).pattern("S").pattern("H").pattern("S").define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('H'), PBTags.ItemTags.ROPE_HERBS).unlockedBy("has_herbs", PBRecipeProvider.has(PBTags.ItemTags.ROPE_HERBS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)PBItems.HERB_POUCH.get())).pattern("#S#").pattern("#H#").pattern("###").define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('H'), PBTags.ItemTags.HERBS).define(Character.valueOf('#'), ItemTags.WOOL).unlockedBy("has_wool", PBRecipeProvider.has((TagKey)ItemTags.WOOL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)PBItems.BOLINE.get())).pattern("I").pattern("S").pattern("B").define(Character.valueOf('S'), (ItemLike)PBItems.BLACK_THORN_STICK.get()).define(Character.valueOf('B'), Tags.Items.BONES).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_wool", PBRecipeProvider.has((TagKey)ItemTags.WOOL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)PBBlocks.HANGING_LAVENDER.get())).pattern(" R ").pattern("HHH").define(Character.valueOf('R'), (ItemLike)PBBlocks.ROPE.get()).define(Character.valueOf('H'), (ItemLike)PBItems.LAVENDER.get()).unlockedBy("has_rope", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.ROPE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)PBBlocks.HANGING_RUE.get())).pattern(" R ").pattern("HHH").define(Character.valueOf('R'), (ItemLike)PBBlocks.ROPE.get()).define(Character.valueOf('H'), (ItemLike)PBItems.RUE.get()).unlockedBy("has_rope", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.ROPE.get()))).save(recipeOutput);
        if (PBItems.PAGAN_GUIDE != null) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)PBItems.PAGAN_GUIDE.get())).requires(PBTags.ItemTags.HERBS).requires((ItemLike)Items.BOOK).group("books").unlockedBy("has_book", PBRecipeProvider.has((ItemLike)Items.BOOK)).save(recipeOutput);
        }
    }

    private static void blackThornWoodRecipes(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()), (int)4).requires((ItemLike)PBBlocks.BLACK_THORN_LOG.get()).group("planks").unlockedBy("has_log", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_LOG.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_SLAB.get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).group("slabs").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_STAIRS.get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).group("stairs").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_BUTTON.get())).requires((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).group("buttons").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PRESSURE_PLATE.get())).pattern("##").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).group("pressure_plates").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_WOOD.get()), (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_LOG.get()).group("barks").unlockedBy("has_log", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_LOG.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.STRIPPED_BLACK_THORN_WOOD.get()), (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)PBBlocks.STRIPPED_BLACK_THORN_LOG.get()).group("barks").unlockedBy("has_stripped_log", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.STRIPPED_BLACK_THORN_LOG.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_FENCE.get()), (int)3).pattern("#S#").pattern("#S#").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).group("fences").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_FENCE_GATE.get())).pattern("S#S").pattern("S#S").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).group("fence_gates").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_TRAPDOOR.get()), (int)2).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).group("trapdoors").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)PBBlocks.BLACK_THORN_DOOR.get()), (int)3).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()).group("doors").unlockedBy("has_planks", PBRecipeProvider.has((ItemLike)((ItemLike)PBBlocks.BLACK_THORN_PLANKS.get()))).save(recipeOutput);
    }
}

