/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.registries;

import com.pigdad.paganbless.compat.modonomicon.ModonomiconCompat;
import com.pigdad.paganbless.content.items.AthameItem;
import com.pigdad.paganbless.content.items.BolineItem;
import com.pigdad.paganbless.content.items.ChaliceItem;
import com.pigdad.paganbless.content.items.ChoppedHerbItem;
import com.pigdad.paganbless.content.items.EternalSnowBallItem;
import com.pigdad.paganbless.content.items.HerbPouchItem;
import com.pigdad.paganbless.content.items.JarItem;
import com.pigdad.paganbless.content.items.PentacleItem;
import com.pigdad.paganbless.content.items.RopeItem;
import com.pigdad.paganbless.content.items.RunicChargeItem;
import com.pigdad.paganbless.content.items.WandItem;
import com.pigdad.paganbless.data.PBDataComponents;
import com.pigdad.paganbless.data.components.AdvancedBundleContents;
import com.pigdad.paganbless.registries.PBBlocks;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class PBItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"paganbless");
    public static final ConcurrentHashMap<Item, Block> INCENSES = new ConcurrentHashMap();
    public static final Supplier<Item> PAGAN_GUIDE;
    public static final Supplier<Item> RUE;
    public static final Supplier<Item> BELLADONNA;
    public static final Supplier<Item> HAG_TAPER;
    public static final Supplier<Item> LAVENDER;
    public static final Supplier<Item> CHOPPED_LAVENDER;
    public static final Supplier<Item> CHOPPED_RUE;
    public static final Supplier<Item> MANDRAKE_ROOT;
    public static final Supplier<Item> MUGWORT;
    public static final Supplier<Item> WINTER_BERRIES;
    public static final Supplier<Item> JAR;
    public static final Supplier<Item> GLAZED_BERRIES;
    public static final Supplier<Item> MECHANICAL_COMPONENT;
    public static final Supplier<Item> CINNABAR;
    public static final Supplier<Item> RUNIC_CHARGE;
    public static final Supplier<Item> WAND;
    public static final Supplier<Item> CHALICE;
    public static final Supplier<Item> ATHAME;
    public static final Supplier<Item> WICAN_WARD;
    public static final Supplier<Item> ETERNAL_SNOWBALL;
    public static final Supplier<Item> WAND_PROJECTILE;
    public static final Supplier<Item> PENTACLE;
    public static final Supplier<Item> BLACK_THORN_STAFF;
    public static final Supplier<Item> STIRRING_STICK;
    public static final Supplier<Item> HERB_POUCH;
    public static final Supplier<Item> BLACK_THORN_STICK;
    public static final Supplier<Item> ROPE;
    public static final Supplier<Item> BOLINE;
    public static final Supplier<Item> ESSENCE_OF_THE_FOREST;

    public static Supplier<Item> registerItem(String name, Supplier<Item> item) {
        return ITEMS.register(name, item);
    }

    static {
        RUE = PBItems.registerItem("rue", () -> new Item(new Item.Properties()));
        BELLADONNA = PBItems.registerItem("belladonna", () -> new Item(new Item.Properties()));
        HAG_TAPER = PBItems.registerItem("hag_taper", () -> new Item(new Item.Properties()));
        LAVENDER = PBItems.registerItem("lavender", () -> new Item(new Item.Properties()));
        CHOPPED_LAVENDER = PBItems.registerItem("chopped_lavender", () -> new ChoppedHerbItem(new Item.Properties(), PBBlocks.LAVENDER_INCENSE.get()));
        CHOPPED_RUE = PBItems.registerItem("chopped_rue", () -> new ChoppedHerbItem(new Item.Properties(), PBBlocks.RUE_INCENSE.get()));
        MANDRAKE_ROOT = PBItems.registerItem("mandrake_root", () -> new Item(new Item.Properties()));
        MUGWORT = PBItems.registerItem("mugwort", () -> new Item(new Item.Properties()));
        WINTER_BERRIES = PBItems.registerItem("winter_berries", () -> new ItemNameBlockItem(PBBlocks.WINTER_BERRY_BUSH.get(), new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).build())));
        JAR = PBItems.registerItem("jar", () -> new JarItem(new Item.Properties().stacksTo(1)));
        GLAZED_BERRIES = PBItems.registerItem("glazed_berries", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(5).saturationModifier(0.4f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED), 1.0f).build())));
        MECHANICAL_COMPONENT = PBItems.registerItem("mechanical_component", () -> new Item(new Item.Properties()));
        CINNABAR = PBItems.registerItem("cinnabar", () -> new Item(new Item.Properties()));
        RUNIC_CHARGE = PBItems.registerItem("runic_charge", () -> new RunicChargeItem(new Item.Properties().stacksTo(16)));
        WAND = PBItems.registerItem("wand", () -> new WandItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE)));
        CHALICE = PBItems.registerItem("chalice", () -> new ChaliceItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE)));
        ATHAME = PBItems.registerItem("athame", () -> new AthameItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE)));
        WICAN_WARD = PBItems.registerItem("wican_ward", () -> new BlockItem(PBBlocks.WICAN_WARD.get(), new Item.Properties().rarity(Rarity.RARE)));
        ETERNAL_SNOWBALL = PBItems.registerItem("eternal_snowball", () -> new EternalSnowBallItem(new Item.Properties().stacksTo(1).rarity(Rarity.RARE)));
        WAND_PROJECTILE = PBItems.registerItem("wand_projectile", () -> new Item(new Item.Properties()));
        PENTACLE = PBItems.registerItem("pentacle", () -> new PentacleItem(new Item.Properties().stacksTo(1).component(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY).rarity(Rarity.RARE)));
        BLACK_THORN_STAFF = PBItems.registerItem("black_thorn_staff", () -> new Item(new Item.Properties().stacksTo(1)));
        STIRRING_STICK = PBItems.registerItem("stirring_stick", () -> new Item(new Item.Properties()));
        HERB_POUCH = PBItems.registerItem("herb_pouch", () -> new HerbPouchItem(new Item.Properties().stacksTo(1).component(PBDataComponents.ADVANCED_BUNDLE_CONTENTS, (Object)AdvancedBundleContents.EMPTY)));
        BLACK_THORN_STICK = PBItems.registerItem("black_thorn_stick", () -> new Item(new Item.Properties()));
        ROPE = PBItems.registerItem("rope", () -> new RopeItem(PBBlocks.ROPE.get(), new Item.Properties()));
        BOLINE = PBItems.registerItem("boline", () -> new BolineItem(new Item.Properties().stacksTo(1)));
        ESSENCE_OF_THE_FOREST = PBItems.registerItem("essence_of_the_forest", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().alwaysEdible().nutrition(4).saturationModifier(1.2f).effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 50), 0.4f).build())));
        PAGAN_GUIDE = ModList.get().isLoaded("modonomicon") ? ModonomiconCompat.registerItem() : null;
    }
}

