/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.utils.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pigdad.paganbless.api.blocks.IncenseBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class RenderUtils {
    public static void renderFloatingItem(ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay, float yPos) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, (double)yPos, 0.5);
            float scale = stack.getItem() instanceof BlockItem ? 0.95f : 0.75f;
            poseStack.scale(scale, scale, scale);
            double tick = (double)System.currentTimeMillis() / 800.0;
            poseStack.translate(0.0, Math.sin(tick % (Math.PI * 2)) * 0.065, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(tick * 40.0 % 360.0)));
            minecraft.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, multiBufferSource, (Level)minecraft.level, 0);
            poseStack.popPose();
        }
    }

    public static void renderBlockModel(BlockState blockState, PoseStack poseStack, MultiBufferSource pBufferSource, int combinedLight, int combinedOverlay) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BakedModel bakedmodel = blockRenderer.getBlockModel(blockState);
        int i = blockRenderer.blockColors.getColor(blockState, null, null, 0);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        for (RenderType rt : bakedmodel.getRenderTypes(blockState, RandomSource.create((long)42L), ModelData.EMPTY)) {
            blockRenderer.modelRenderer.renderModel(poseStack.last(), pBufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), blockState, bakedmodel, f, f1, f2, combinedLight, combinedOverlay, ModelData.EMPTY, rt);
        }
    }

    public static void rotateCentered(PoseStack poseStack, Axis axis, float radians) {
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(axis.rotationDegrees(radians));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
    }

    public static void rotateCentered(PoseStack poseStack, Direction direction, float degrees) {
        Vector3f step = direction.step();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(new Quaternionf().setAngleAxis(Math.toRadians(degrees), (double)step.x(), (double)step.y(), (double)step.z()));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
    }

    public static void performBlockRotation16(BlockState blockState, PoseStack poseStack) {
        if (blockState.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            int rotation = (Integer)blockState.getValue((Property)IncenseBlock.ROTATION);
            float degrees = RotationSegment.convertToDegrees((int)rotation);
            RenderUtils.rotateCentered(poseStack, Axis.YN, degrees);
        }
    }
}

