/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility;

import com.heaser.pipeconnector.compatibility.ae2.AE2Compatiblity;
import com.heaser.pipeconnector.compatibility.interfaces.IDirectionGetter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class CompatibilityDirectionGetter {
    private static CompatibilityDirectionGetter INSTANCE;
    private final HashMap<Class<? extends Item>, IDirectionGetter> classToGetterMap = new HashMap();

    private CompatibilityDirectionGetter() {
        if (this.isModLoaded("ae2")) {
            this.classToGetterMap.put(AE2Compatiblity.getItemStackClassToRegister(), new AE2Compatiblity());
        }
    }

    private boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static CompatibilityDirectionGetter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompatibilityDirectionGetter();
        }
        return INSTANCE;
    }

    public Direction defaultGetDirection(UseOnContext context) {
        return context.getClickedFace();
    }

    @Nullable
    public Direction getDirection(UseOnContext context) {
        IDirectionGetter getter = null;
        for (Map.Entry<Class<? extends Item>, IDirectionGetter> set : this.classToGetterMap.entrySet()) {
            Player player = context.getPlayer();
            if (player == null || !set.getKey().isAssignableFrom(player.getOffhandItem().getItem().getClass())) continue;
            getter = set.getValue();
            break;
        }
        if (getter != null) {
            return getter.getDirection(context);
        }
        return this.defaultGetDirection(context);
    }
}

