/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.neoforge;

import com.blackgear.platform.Platform;
import com.blackgear.platform.client.GameRendering;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

public class GameRenderingImpl {
    public static void registerBlockColors(Consumer<GameRendering.BlockColorEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> listener.accept(new GameRendering.BlockColorEvent((RegisterColorHandlersEvent.Block)event){
            final /* synthetic */ RegisterColorHandlersEvent.Block val$event;
            {
                this.val$event = block;
            }

            @Override
            public void register(BlockColor color, Block ... blocks) {
                this.val$event.register(color, blocks);
            }

            @Override
            public int getColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int tint) {
                return this.val$event.getBlockColors().getColor(state, level, pos, tint);
            }
        }));
    }

    public static void registerItemColors(Consumer<GameRendering.ItemColorEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> listener.accept(new GameRendering.ItemColorEvent((RegisterColorHandlersEvent.Item)event){
            final /* synthetic */ RegisterColorHandlersEvent.Item val$event;
            {
                this.val$event = item;
            }

            @Override
            public void register(ItemColor color, ItemLike ... items) {
                this.val$event.register(color, items);
            }

            @Override
            public int getColor(ItemStack stack, int tint) {
                Item item = stack.getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    BlockState state = blockItem.getBlock().defaultBlockState();
                    return this.val$event.getBlockColors().getColor(state, null, null, tint);
                }
                return 0xFFFFFF;
            }
        }));
    }

    public static void registerBlockRenderers(Consumer<GameRendering.BlockRendererEvent> listener) {
        listener.accept(new GameRendering.BlockRendererEvent(){

            @Override
            public void register(RenderType type, Block ... blocks) {
                for (Block block : blocks) {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
                }
            }

            @Override
            public void register(RenderType type, Fluid ... fluids) {
                for (Fluid fluid : fluids) {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
                }
            }
        });
    }

    public static void registerEntityRenderers(Consumer<GameRendering.EntityRendererEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1)));
    }

    public static void registerBlockEntityRenderers(Consumer<GameRendering.BlockEntityRendererEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1)));
    }

    public static void registerModelLayers(Consumer<GameRendering.ModelLayerEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1)));
    }

    public static void registerSpecialModels(Consumer<GameRendering.SpecialModelEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            GameRendering.SpecialModelEvent modelEvent = new GameRendering.SpecialModelEvent((ModelEvent.RegisterAdditional)event){
                final /* synthetic */ ModelEvent.RegisterAdditional val$event;
                {
                    this.val$event = registerAdditional;
                }

                @Override
                public void register(ResourceLocation model) {
                    this.val$event.register(new ModelResourceLocation(GameRenderingImpl.wrapModel(model), "standalone"));
                }

                @Override
                public void register(ResourceLocation ... models) {
                    for (ResourceLocation model : models) {
                        this.register(model);
                    }
                }
            };
            listener.accept(modelEvent);
        });
    }

    public static void registerModelOverrides(Consumer<GameRendering.ModelOverrideEvent> listener) {
        listener.accept(new GameRendering.ModelOverrideEvent(){});
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            Map registry = event.getModels();
            for (Map.Entry<ResourceLocation, ResourceLocation> entry : GameRendering.MODEL_OVERRIDES.entrySet()) {
                ModelResourceLocation originalModel = new ModelResourceLocation(entry.getKey(), "inventory");
                ModelResourceLocation overrideModel = new ModelResourceLocation(GameRenderingImpl.wrapModel(entry.getValue()), "standalone");
                BakedModel overridenModel = (BakedModel)registry.get(overrideModel);
                if (overridenModel != null) {
                    registry.put(originalModel, overridenModel);
                    continue;
                }
                Platform.LOGGER.error("Failed to find custom model: {}", (Object)overrideModel);
            }
        });
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            for (ResourceLocation override : GameRendering.MODEL_OVERRIDES.values()) {
                event.register(new ModelResourceLocation(GameRenderingImpl.wrapModel(override), "standalone"));
            }
        });
    }

    private static ResourceLocation wrapModel(ResourceLocation model) {
        return ResourceLocation.fromNamespaceAndPath((String)model.getNamespace(), (String)("item/" + model.getPath()));
    }

    public static void registerSkullRenderers(Consumer<GameRendering.SkullRendererEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            GameRendering.SkullRendererEvent skullEvent = new GameRendering.SkullRendererEvent((EntityRenderersEvent.CreateSkullModels)event){
                final /* synthetic */ EntityRenderersEvent.CreateSkullModels val$event;
                {
                    this.val$event = createSkullModels;
                }

                @Override
                public void registerSkullModel(SkullBlock.Type type, Function<ModelPart, SkullModelBase> model, ModelLayerLocation layer) {
                    this.val$event.registerSkullModel(type, model.apply(this.val$event.getEntityModelSet().bakeLayer(layer)));
                }

                @Override
                public void registerSkullTexture(SkullBlock.Type type, ResourceLocation texture) {
                    SkullBlockRenderer.SKIN_BY_TYPE.put(type, texture);
                }
            };
            listener.accept(skullEvent);
        });
    }

    public static void registerParticleFactories(Consumer<GameRendering.ParticleFactoryEvent> listener) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            GameRendering.ParticleFactoryEvent factoryEvent = new GameRendering.ParticleFactoryEvent((RegisterParticleProvidersEvent)event){
                final /* synthetic */ RegisterParticleProvidersEvent val$event;
                {
                    this.val$event = registerParticleProvidersEvent;
                }

                @Override
                public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> type, ParticleProvider<T> provider) {
                    this.val$event.registerSpecial((ParticleType)type.get(), provider);
                }

                @Override
                public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> type, GameRendering.ParticleFactoryEvent.Factory<T> factory) {
                    this.val$event.registerSpriteSet((ParticleType)type.get(), factory::create);
                }
            };
            listener.accept(factoryEvent);
        });
    }
}

