/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;

public class BuiltInCoreRegistry<T> {
    private final Map<ResourceLocation, T> hardcodedEntries = new HashMap<ResourceLocation, T>();
    private final Map<ResourceLocation, T> dataDrivenEntries = new HashMap<ResourceLocation, T>();
    private final String modId;
    private final Registry<T> registry;
    protected boolean isPresent = false;

    public BuiltInCoreRegistry(Registry<T> registry, String modId) {
        this.modId = modId;
        this.registry = registry;
        this.registry.keySet().forEach(id -> this.hardcodedEntries.putIfAbsent((ResourceLocation)id, (T)this.registry.get(id)));
    }

    public T register(ResourceLocation name, T entry) {
        return this.hardcodedEntries.put(name, entry);
    }

    public T register(String name, T entry) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name);
        return this.hardcodedEntries.put(location, entry);
    }

    public T registerDataDriven(ResourceLocation name, T entry) {
        return this.dataDrivenEntries.put(name, entry);
    }

    public <E extends T> ResourceKey<T> resource(String name, E entry) {
        this.register(name, entry);
        return ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name));
    }

    public T getOrDefault(ResourceLocation name, T fallback) {
        if (this.registry.containsKey(name)) {
            return (T)this.registry.get(name);
        }
        if (this.dataDrivenEntries.containsKey(name)) {
            return this.dataDrivenEntries.get(name);
        }
        if (this.hardcodedEntries.containsKey(name)) {
            return this.hardcodedEntries.get(name);
        }
        return fallback;
    }

    public T get(ResourceLocation name) {
        if (this.dataDrivenEntries.containsKey(name)) {
            return this.dataDrivenEntries.get(name);
        }
        return this.hardcodedEntries.get(name);
    }

    public T get(ResourceKey<T> name) {
        return this.getOrDefault(name.location(), null);
    }

    public T getOrThrow(ResourceKey<T> key) {
        T value = this.get(key);
        if (value == null) {
            ResourceKey resource = this.registry.key();
            throw new IllegalStateException("Missing key in " + String.valueOf(resource) + ":" + String.valueOf(key));
        }
        return value;
    }

    public ResourceLocation getKey(T value) {
        Optional<ResourceLocation> dataDrivenKey = this.dataDrivenEntries.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), value)).findFirst().map(Map.Entry::getKey);
        return dataDrivenKey.orElseGet(() -> (ResourceLocation)this.hardcodedEntries.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Value not found in registry: " + String.valueOf(value))).getKey());
    }

    public Optional<List<T>> fromTag(TagKey<T> tag) {
        List<Object> values = this.getAllEntries().values().stream().filter(value -> Holder.direct((Object)value).is(tag)).toList();
        return values.isEmpty() ? Optional.empty() : Optional.of(values);
    }

    public Optional<T> getRandomFromTag(TagKey<T> tag, RandomSource random) {
        return this.fromTag(tag).map(values -> this.getRandomElement((Collection<T>)values, random));
    }

    public T getRandomElement(Collection<T> collection, RandomSource random) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Cannot get random element from empty collection");
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(random.nextInt(list.size()));
        }
        int index = random.nextInt(collection.size());
        Iterator<T> iterator = collection.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public T getRandomElement(RandomSource random) {
        Map<ResourceLocation, T> allEntries = this.getAllEntries();
        if (allEntries.isEmpty()) {
            throw new IllegalStateException("Registry is empty");
        }
        return this.getRandomElement(allEntries.values(), random);
    }

    private Map<ResourceLocation, T> getAllEntries() {
        HashMap<ResourceLocation, T> combined = new HashMap<ResourceLocation, T>(this.hardcodedEntries);
        combined.putAll(this.dataDrivenEntries);
        return combined;
    }

    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.getAllEntries().values());
    }

    public Map<ResourceLocation, T> entries() {
        return Collections.unmodifiableMap(this.getAllEntries());
    }

    public void clearDataDrivenEntries() {
        this.dataDrivenEntries.clear();
    }

    public void register() {
        if (this.isPresent) {
            throw new IllegalStateException("Duplication of BuiltIn-Registry: " + String.valueOf(this.registry));
        }
        this.isPresent = true;
    }
}

