/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.IKeyListener;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import net.minecraft.client.KeyMapping;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

public enum KeyHandler {
    INSTANCE;

    private static final String DESCRIPTION_ARMOR_OPTIONS = "pneumaticcraft.armor.options";
    private static final String DESCRIPTION_HELMET_HACK = "pneumaticcraft.helmet.hack";
    private static final String DESCRIPTION_HELMET_DEBUGGING_DRONE = "pneumaticcraft.helmet.debugging.drone";
    private static final String DESCRIPTION_BOOTS_KICK = "pneumaticcraft.boots.kick";
    private static final String DESCRIPTION_LAUNCHER = "pneumaticcraft.chestplate.launcher";
    private static final String DESCRIPTION_JET_BOOTS = "pneumaticcraft.boots.jet_boots";
    public final KeyMapping keybindOpenOptions;
    public final KeyMapping keybindHack;
    public final KeyMapping keybindDebuggingDrone;
    public final KeyMapping keybindKick;
    public final KeyMapping keybindLauncher;
    public final KeyMapping keybindJetBoots;
    private final List<IKeyListener> keyListeners = new ArrayList<IKeyListener>();
    private final List<KeyMapping> knownKeyMappings = new ArrayList<KeyMapping>();

    public static KeyHandler getInstance() {
        return INSTANCE;
    }

    private KeyHandler() {
        this.registerKeyListener(HUDHandler.getInstance());
        this.keybindOpenOptions = this.addKnownMapping(new KeyMapping(DESCRIPTION_ARMOR_OPTIONS, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 85, "key.pneumaticcraft.category.main"));
        this.keybindHack = this.addKnownMapping(new KeyMapping(DESCRIPTION_HELMET_HACK, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 72, "key.pneumaticcraft.category.main"));
        this.keybindDebuggingDrone = this.addKnownMapping(new KeyMapping(DESCRIPTION_HELMET_DEBUGGING_DRONE, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 89, "key.pneumaticcraft.category.main"));
        this.keybindKick = this.addKnownMapping(new KeyMapping(DESCRIPTION_BOOTS_KICK, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 88, "key.pneumaticcraft.category.main"));
        this.keybindLauncher = this.addKnownMapping(new KeyMapping(DESCRIPTION_LAUNCHER, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 67, "key.pneumaticcraft.category.main"));
        this.keybindJetBoots = this.addKnownMapping(new KeyMapping(DESCRIPTION_JET_BOOTS, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 32, "key.pneumaticcraft.category.main"));
    }

    private KeyMapping addKnownMapping(KeyMapping key) {
        this.knownKeyMappings.add(key);
        return key;
    }

    public void registerKeyMappings(RegisterKeyMappingsEvent event) {
        this.knownKeyMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @SubscribeEvent
    public void onKey(InputEvent.Key event) {
        this.knownKeyMappings.stream().filter(KeyMapping::consumeClick).forEach(this::dispatchInput);
    }

    @SubscribeEvent
    public void onMouse(InputEvent.MouseButton.Post event) {
        this.knownKeyMappings.stream().filter(KeyMapping::consumeClick).forEach(this::dispatchInput);
    }

    private void registerKeyListener(IKeyListener listener) {
        this.keyListeners.add(listener);
    }

    private void dispatchInput(KeyMapping keyMapping) {
        this.keyListeners.forEach(listener -> listener.handleInput(keyMapping));
    }
}

