/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetAreaShowScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ProgWidgetAreaScreen
extends ProgWidgetAreaShowScreen<ProgWidgetArea> {
    private InventorySearcherScreen invSearchGui;
    private int pointSearched;
    private WidgetComboBox variableField1;
    private WidgetComboBox variableField2;
    private final List<? extends AreaType> allAreaTypes = ProgWidgetArea.getAllAreaTypes();
    private final List<Pair<AreaTypeWidget, AbstractWidget>> areaTypeValueWidgets = new ArrayList<Pair<AreaTypeWidget, AbstractWidget>>();
    private final List<AbstractWidget> areaTypeStaticWidgets = new ArrayList<AbstractWidget>();

    public ProgWidgetAreaScreen(ProgWidgetArea widget, ProgrammerScreen guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 256;
    }

    @Override
    public void init() {
        super.init();
        boolean advancedMode = ConfigHelper.client().general.programmerDifficulty.get() == IProgWidget.WidgetDifficulty.ADVANCED;
        WidgetButtonExtended gpsButton1 = new WidgetButtonExtended(this.guiLeft + (advancedMode ? 6 : 55), this.guiTop + 30, 20, 20, (Component)Component.empty(), b -> this.openInvSearchGUI(0)).setRenderStacks(new ItemStack((ItemLike)ModItems.GPS_TOOL.get())).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.selectGPS1", new Object[0]));
        this.addRenderableWidget((GuiEventListener)gpsButton1);
        WidgetButtonExtended gpsButton2 = new WidgetButtonExtended(this.guiLeft + (advancedMode ? 133 : 182), this.guiTop + 30, 20, 20, (Component)Component.empty(), b -> this.openInvSearchGUI(1)).setRenderStacks(new ItemStack((ItemLike)ModItems.GPS_TOOL.get())).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.selectGPS2", new Object[0]));
        this.addRenderableWidget((GuiEventListener)gpsButton2);
        Objects.requireNonNull(this.font);
        this.variableField1 = new WidgetComboBox(this.font, this.guiLeft + 28, this.guiTop + 34, 88, 9 + 3);
        Objects.requireNonNull(this.font);
        this.variableField2 = new WidgetComboBox(this.font, this.guiLeft + 155, this.guiTop + 34, 88, 9 + 3);
        Set<String> variables = this.guiProgrammer == null ? Collections.emptySet() : ((ProgrammerBlockEntity)this.guiProgrammer.te).getAllVariables();
        this.variableField1.setElements(variables);
        this.variableField2.setElements(variables);
        this.variableField1.setValue(((ProgWidgetArea)this.progWidget).getVarName(0));
        this.variableField2.setValue(((ProgWidgetArea)this.progWidget).getVarName(1));
        if (advancedMode) {
            this.addRenderableWidget((GuiEventListener)this.variableField1);
            this.addRenderableWidget((GuiEventListener)this.variableField2);
        }
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.type", new Object[0]), this.guiLeft + 8, this.guiTop + 88);
        int widgetsPerColumn = 5;
        WidgetRadioButton.Builder<WidgetRadioButton> builder = WidgetRadioButton.Builder.create();
        for (int i = 0; i < this.allAreaTypes.size(); ++i) {
            AreaType areaType = this.allAreaTypes.get(i);
            WidgetRadioButton radioButton = new WidgetRadioButton(this.guiLeft + 5 + i / 5 * 80, this.guiTop + 100 + i % 5 * 12, -12566464, (Component)PneumaticCraftUtils.xlate(areaType.getTranslationKey(), new Object[0]), b -> {
                ((ProgWidgetArea)this.progWidget).setAreaType(areaType);
                this.switchToWidgets(areaType);
            });
            builder.addRadioButton(radioButton, ((ProgWidgetArea)this.progWidget).getAreaType().getName().equals(areaType.getName()));
        }
        builder.build(x$0 -> {
            WidgetRadioButton cfr_ignored_0 = (WidgetRadioButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.switchToWidgets(((ProgWidgetArea)this.progWidget).getAreaType());
        if (this.invSearchGui != null) {
            ((ProgWidgetArea)this.progWidget).setPos(this.pointSearched, this.invSearchGui.getBlockPos());
            this.invSearchGui = null;
        }
        String l1 = "P1: " + String.valueOf(ChatFormatting.DARK_BLUE) + this.formatPos(((ProgWidgetArea)this.progWidget).getPos(0).orElse(PneumaticCraftUtils.invalidPos()));
        this.addLabel((Component)Component.literal((String)l1), this.guiLeft + 8, this.guiTop + 20);
        String l2 = "P2: " + String.valueOf(ChatFormatting.DARK_BLUE) + this.formatPos(((ProgWidgetArea)this.progWidget).getPos(1).orElse(PneumaticCraftUtils.invalidPos()));
        this.addLabel((Component)Component.literal((String)l2), this.guiLeft + 133, this.guiTop + 20);
    }

    private String formatPos(BlockPos pos) {
        return PneumaticCraftUtils.isValidPos(pos) ? String.format("[ %d, %d, %d ]", pos.getX(), pos.getY(), pos.getZ()) : "-";
    }

    private void openInvSearchGUI(int which) {
        ItemStack gpsStack = new ItemStack((ItemLike)ModItems.GPS_TOOL.get());
        GPSToolItem.setGPSLocation(ClientUtils.getClientPlayer().getUUID(), gpsStack, ((ProgWidgetArea)this.progWidget).getPos(which).orElse(BlockPos.ZERO));
        ClientUtils.openContainerGui(ModMenuTypes.INVENTORY_SEARCHER.get(), (Component)Component.literal((String)"Inventory Searcher (GPS)"));
        if (this.minecraft.screen instanceof InventorySearcherScreen) {
            this.invSearchGui = (InventorySearcherScreen)this.minecraft.screen;
            this.invSearchGui.setStackPredicate(itemStack -> itemStack.getItem() instanceof IPositionProvider);
            this.invSearchGui.setSearchStack(GPSToolItem.getGPSLocation(gpsStack).isPresent() ? gpsStack : ItemStack.EMPTY);
        }
        this.pointSearched = which;
    }

    private void switchToWidgets(AreaType type) {
        this.saveWidgets();
        this.areaTypeValueWidgets.forEach(p -> this.removeWidget((GuiEventListener)p.getRight()));
        this.areaTypeStaticWidgets.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.areaTypeValueWidgets.clear();
        this.areaTypeStaticWidgets.clear();
        int curY = this.guiTop + 100;
        int x = this.guiLeft + 150;
        ArrayList<AreaTypeWidget> atWidgets = new ArrayList<AreaTypeWidget>();
        type.addUIWidgets(atWidgets);
        block4: for (AreaTypeWidget areaTypeWidget : atWidgets) {
            AreaTypeWidget areaTypeWidget2;
            WidgetLabel titleWidget = new WidgetLabel(x, curY, (Component)PneumaticCraftUtils.xlate(areaTypeWidget.getTranslationKey(), new Object[0]));
            this.addRenderableWidget((GuiEventListener)titleWidget);
            this.areaTypeStaticWidgets.add(titleWidget);
            Objects.requireNonNull(this.font);
            curY += 9 + 1;
            Objects.requireNonNull(areaTypeWidget);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AreaTypeWidget.IntegerField.class, AreaTypeWidget.EnumSelectorField.class}, (Object)areaTypeWidget2, n)) {
                case 0: {
                    AreaTypeWidget.IntegerField intWidget = (AreaTypeWidget.IntegerField)areaTypeWidget2;
                    Objects.requireNonNull(this.font);
                    WidgetTextFieldNumber intField = new WidgetTextFieldNumber(this.font, x, curY, 40, 9 + 1).setRange(0, Integer.MAX_VALUE);
                    intField.setValue(intWidget.readAction.getAsInt());
                    this.addRenderableWidget((GuiEventListener)intField);
                    this.areaTypeValueWidgets.add((Pair<AreaTypeWidget, AbstractWidget>)new ImmutablePair((Object)areaTypeWidget, (Object)intField));
                    Objects.requireNonNull(this.font);
                    curY += 9 + 20;
                    continue block4;
                }
                case 1: {
                    AreaTypeWidget.EnumSelectorField enumWidget = (AreaTypeWidget.EnumSelectorField)areaTypeWidget2;
                    Objects.requireNonNull(this.font);
                    WidgetComboBox enumCbb = new WidgetComboBox(this.font, x, curY, 80, 9 + 3).setFixedOptions(true);
                    enumCbb.setElements(this.getEnumNames(enumWidget.enumClass));
                    String txt = PneumaticCraftUtils.xlate(((ITranslatableEnum)enumWidget.readAction.get()).getTranslationKey(), new Object[0]).getString();
                    enumCbb.setValue(txt);
                    this.addRenderableWidget((GuiEventListener)enumCbb);
                    this.areaTypeValueWidgets.add((Pair<AreaTypeWidget, AbstractWidget>)new ImmutablePair((Object)areaTypeWidget, (Object)enumCbb));
                    Objects.requireNonNull(this.font);
                    curY += 9 + 20;
                    continue block4;
                }
            }
            throw new IllegalStateException("Invalid widget type: " + String.valueOf(areaTypeWidget.getClass()));
        }
    }

    private void saveWidgets() {
        for (Pair<AreaTypeWidget, AbstractWidget> entry : this.areaTypeValueWidgets) {
            AreaTypeWidget widget = (AreaTypeWidget)entry.getLeft();
            AbstractWidget guiWidget = (AbstractWidget)entry.getRight();
            if (widget instanceof AreaTypeWidget.IntegerField) {
                AreaTypeWidget.IntegerField intWidget = (AreaTypeWidget.IntegerField)widget;
                intWidget.writeAction.accept(((WidgetTextFieldNumber)guiWidget).getIntValue());
                continue;
            }
            if (!(widget instanceof AreaTypeWidget.EnumSelectorField)) continue;
            AreaTypeWidget.EnumSelectorField enumWidget = (AreaTypeWidget.EnumSelectorField)widget;
            WidgetComboBox cbb = (WidgetComboBox)guiWidget;
            List<String> enumNames = this.getEnumNames(enumWidget.enumClass);
            E[] enumValues = enumWidget.enumClass.getEnumConstants();
            Object e = enumValues[enumNames.indexOf(cbb.getValue())];
            if (!(e instanceof ITranslatableEnum)) continue;
            ITranslatableEnum tr = (ITranslatableEnum)e;
            enumWidget.writeAction.accept(tr);
        }
    }

    private List<String> getEnumNames(Class<?> enumClass) {
        ?[] enumValues = enumClass.getEnumConstants();
        ArrayList<String> enumNames = new ArrayList<String>();
        for (Object enumValue : enumValues) {
            if (enumValue instanceof ITranslatableEnum) {
                ITranslatableEnum t = (ITranslatableEnum)enumValue;
                enumNames.add(PneumaticCraftUtils.xlate(t.getTranslationKey(), new Object[0]).getString());
                continue;
            }
            enumNames.add(enumValue.toString());
        }
        return enumNames;
    }

    @Override
    protected void previewArea(WidgetCheckBox button) {
        super.previewArea(button);
        this.saveWidgets();
    }

    @Override
    public void removed() {
        ((ProgWidgetArea)this.progWidget).setVarName(0, this.variableField1.getValue());
        ((ProgWidgetArea)this.progWidget).setVarName(1, this.variableField2.getValue());
        this.saveWidgets();
        super.removed();
    }
}

