/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.config;

import java.util.Objects;
import me.desht.pneumaticcraft.api.remote.WidgetSettings;
import me.desht.pneumaticcraft.client.gui.remote.AbstractRemoteScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteClientRegistry;
import me.desht.pneumaticcraft.client.gui.remote.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.config.AbstractRemoteVariableConfigScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.remote.RemoteWidgetButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RemoteButtonOptionScreen
extends AbstractRemoteVariableConfigScreen<RemoteWidgetButton> {
    private WidgetTextFieldNumber widthField;
    private WidgetTextFieldNumber heightField;
    private WidgetTextFieldNumber xValueField;
    private WidgetTextFieldNumber yValueField;
    private WidgetTextFieldNumber zValueField;

    public RemoteButtonOptionScreen(RemoteWidgetButton widget, RemoteEditorScreen guiRemote) {
        super(widget, guiRemote);
    }

    @Override
    public void init() {
        super.init();
        Objects.requireNonNull(this.font);
        int textFieldHeight = 9 + 3;
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.settingValue", new Object[0]), this.guiLeft + 10, this.guiTop + 95);
        this.addLabel((Component)Component.literal((String)"X:"), this.guiLeft + 10, this.guiTop + 106);
        this.addLabel((Component)Component.literal((String)"Y:"), this.guiLeft + 67, this.guiTop + 106);
        this.addLabel((Component)Component.literal((String)"Z:"), this.guiLeft + 124, this.guiTop + 106);
        WidgetLabel lw = this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.width", new Object[0]), this.guiLeft + 10, this.guiTop + 123);
        WidgetLabel lh = this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.height", new Object[0]), this.guiLeft + 10, this.guiTop + 136);
        int xOff = this.guiLeft + 13 + Math.max(lw.getWidth(), lh.getWidth());
        lw.setX(xOff - (lw.getWidth() + 3));
        lh.setX(xOff - (lh.getWidth() + 3));
        MutableComponent valueTooltip = PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.value.tooltip", new Object[0]);
        this.xValueField = new WidgetTextFieldNumber(this.font, this.guiLeft + 20, this.guiTop + 104, 38, textFieldHeight);
        this.xValueField.setValue(((RemoteWidgetButton)this.remoteWidget).settingPos().getX());
        this.xValueField.setTooltip(Tooltip.create((Component)valueTooltip));
        this.addRenderableWidget((GuiEventListener)this.xValueField);
        this.yValueField = new WidgetTextFieldNumber(this.font, this.guiLeft + 78, this.guiTop + 104, 38, textFieldHeight);
        this.yValueField.setValue(((RemoteWidgetButton)this.remoteWidget).settingPos().getY());
        this.yValueField.setTooltip(Tooltip.create((Component)valueTooltip));
        this.addRenderableWidget((GuiEventListener)this.yValueField);
        this.zValueField = new WidgetTextFieldNumber(this.font, this.guiLeft + 136, this.guiTop + 104, 38, textFieldHeight);
        this.zValueField.setValue(((RemoteWidgetButton)this.remoteWidget).settingPos().getZ());
        this.zValueField.setTooltip(Tooltip.create((Component)valueTooltip));
        this.addRenderableWidget((GuiEventListener)this.zValueField);
        this.widthField = new WidgetTextFieldNumber(this.font, xOff, this.guiTop + 121, 35, textFieldHeight).setRange(10, Integer.MAX_VALUE).setAdjustments(1.0, 10.0);
        this.widthField.setValue(((RemoteWidgetButton)this.remoteWidget).widgetSettings().width());
        this.widthField.minValue = 10;
        this.addRenderableWidget((GuiEventListener)this.widthField);
        this.heightField = new WidgetTextFieldNumber(this.font, xOff, this.guiTop + 134, 35, textFieldHeight).setRange(10, Integer.MAX_VALUE).setAdjustments(1.0, 10.0);
        this.heightField.setValue(((RemoteWidgetButton)this.remoteWidget).widgetSettings().height());
        this.heightField.minValue = 10;
        this.heightField.maxValue = 20;
        this.addRenderableWidget((GuiEventListener)this.heightField);
    }

    @Override
    protected RemoteWidgetButton makeUpdatedRemoteWidget() {
        return new RemoteWidgetButton(this.makeBaseSettings(), this.makeWidgetSettings().resize(this.widthField.getIntValue(), this.heightField.getIntValue()), this.makeVarName(), new BlockPos(this.xValueField.getIntValue(), this.yValueField.getIntValue(), this.zValueField.getIntValue()));
    }

    public static enum Factory implements RemoteClientRegistry.Factory<RemoteWidgetButton, WidgetButtonExtended>
    {
        INSTANCE;


        @Override
        public WidgetButtonExtended createMinecraftWidget(RemoteWidgetButton remoteWidget, AbstractRemoteScreen screen) {
            WidgetSettings widgetSettings = remoteWidget.widgetSettings();
            return new WidgetButtonExtended(widgetSettings.x() + screen.getGuiLeft(), widgetSettings.y() + screen.getGuiTop(), widgetSettings.width(), widgetSettings.height(), widgetSettings.title(), btn -> {
                if (!remoteWidget.varName().isEmpty()) {
                    NetworkHandler.sendToServer(PacketSetGlobalVariable.forPos(remoteWidget.varName(), remoteWidget.settingPos()));
                }
            }).setTooltipText(remoteWidget.widgetSettings().tooltip());
        }

        @Override
        public Screen createConfigurationScreen(RemoteWidgetButton remoteWidget, RemoteEditorScreen screen) {
            return new RemoteButtonOptionScreen(remoteWidget, screen);
        }
    }
}

