/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.config;

import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.remote.BaseSettings;
import me.desht.pneumaticcraft.api.remote.WidgetSettings;
import me.desht.pneumaticcraft.client.gui.remote.AbstractRemoteScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteClientRegistry;
import me.desht.pneumaticcraft.client.gui.remote.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.config.AbstractRemoteVariableConfigScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.remote.RemoteWidgetDropdown;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RemoteDropdownOptionScreen
extends AbstractRemoteVariableConfigScreen<RemoteWidgetDropdown> {
    private WidgetTextField dropDownElementsField;
    private WidgetTextFieldNumber widthField;
    private WidgetCheckBox sortCheckBox;

    public RemoteDropdownOptionScreen(RemoteWidgetDropdown widget, RemoteEditorScreen guiRemote) {
        super(widget, guiRemote);
    }

    @Override
    public void init() {
        super.init();
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.width", new Object[0]), this.guiLeft + 10, this.guiTop + 100);
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.dropdown.dropDownElements", new Object[0]), this.guiLeft + 10, this.guiTop + 40);
        this.dropDownElementsField = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 49, 160);
        this.dropDownElementsField.setMaxLength(1024);
        this.dropDownElementsField.setValue(String.join((CharSequence)",", ((RemoteWidgetDropdown)this.remoteWidget).elements()));
        this.dropDownElementsField.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.dropdown.dropDownElements.tooltip", new Object[0])));
        this.addRenderableWidget((GuiEventListener)this.dropDownElementsField);
        this.widthField = new WidgetTextFieldNumber(this.font, this.guiLeft + 49, this.guiTop + 99, 30).setRange(10, Integer.MAX_VALUE);
        this.widthField.setValue(((RemoteWidgetDropdown)this.remoteWidget).widgetSettings().width());
        this.widthField.minValue = 10;
        this.addRenderableWidget((GuiEventListener)this.widthField);
        this.sortCheckBox = new WidgetCheckBox(this.guiLeft + 10, this.guiTop + 120, 0x404040, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.dropdown.sort", new Object[0])).setChecked(((RemoteWidgetDropdown)this.remoteWidget).sorted());
        this.sortCheckBox.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.dropdown.sort.tooltip", new Object[0])));
        this.addRenderableWidget((GuiEventListener)this.sortCheckBox);
    }

    @Override
    protected RemoteWidgetDropdown makeUpdatedRemoteWidget() {
        BaseSettings baseSettings = this.makeBaseSettings();
        WidgetSettings widgetSettings = this.makeWidgetSettings();
        int n = this.widthField.getIntValue();
        Objects.requireNonNull(Minecraft.getInstance().font);
        return new RemoteWidgetDropdown(baseSettings, widgetSettings.resize(n, 9 + 3), this.makeVarName(), List.of(this.dropDownElementsField.getValue().split(",")), this.sortCheckBox.isChecked());
    }

    public static enum Factory implements RemoteClientRegistry.Factory<RemoteWidgetDropdown, WidgetComboBox>
    {
        INSTANCE;


        @Override
        public WidgetComboBox createMinecraftWidget(RemoteWidgetDropdown remoteWidget, AbstractRemoteScreen screen) {
            Font font = Minecraft.getInstance().font;
            int n = remoteWidget.widgetSettings().x() + screen.getGuiLeft();
            int n2 = remoteWidget.widgetSettings().y() + screen.getGuiTop();
            int n3 = remoteWidget.widgetSettings().width();
            Objects.requireNonNull(Minecraft.getInstance().font);
            WidgetComboBox res = new WidgetComboBox(font, n, n2, n3, 9 + 3, btn -> {
                if (btn.getSelectedElementIndex() >= 0 && !remoteWidget.varName().isEmpty()) {
                    NetworkHandler.sendToServer(PacketSetGlobalVariable.forInt(remoteWidget.varName(), btn.getSelectedElementIndex()));
                }
            });
            res.setElements(remoteWidget.elements());
            res.setFixedOptions(true);
            res.setShouldSort(remoteWidget.sorted());
            res.setValue(remoteWidget.getSelectedElement());
            res.setTooltip(Tooltip.create((Component)remoteWidget.widgetSettings().tooltip()));
            return res;
        }

        @Override
        public Screen createConfigurationScreen(RemoteWidgetDropdown remoteWidget, RemoteEditorScreen screen) {
            return new RemoteDropdownOptionScreen(remoteWidget, screen);
        }

        @Override
        public void handleGlobalVariableChange(RemoteWidgetDropdown remoteWidget, WidgetComboBox mcWidget, String varName) {
            int idx = GlobalVariableHelper.getInstance().getInt(ClientUtils.getClientPlayer().getUUID(), varName);
            mcWidget.selectElement(idx);
        }
    }
}

