/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.semiblock;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.client.gui.semiblock.LogisticsLiquidFilterScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.LogisticsRequesterEntity;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.inventory.slot.PhantomSlot;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.fluids.FluidStack;

public class AbstractLogisticsScreen<L extends AbstractLogisticsFrameEntity>
extends AbstractPneumaticCraftContainerScreen<LogisticsMenu, AbstractPneumaticCraftBlockEntity> {
    protected final L logistics;
    private ItemSearcherScreen itemSearchGui;
    private LogisticsLiquidFilterScreen fluidSearchGui;
    private int editingSlot;
    protected WidgetLabel itemLabel;
    protected WidgetLabel fluidLabel;
    private WidgetButtonExtended itemWhitelist;
    private WidgetButtonExtended fluidWhitelist;
    private final List<WidgetFluidStack> fluidWidgets = new ArrayList<WidgetFluidStack>();
    private WidgetTextFieldNumber minItemsField;
    private WidgetTextFieldNumber minFluidField;

    public AbstractLogisticsScreen(LogisticsMenu menu, Inventory inv, Component displayString) {
        super(menu, inv, displayString);
        this.logistics = menu.logistics;
        this.imageHeight = 216;
    }

    @Override
    public void init() {
        super.init();
        if (this.itemSearchGui != null) {
            this.updateItemFilter(this.editingSlot, this.itemSearchGui.getSearchStack());
            this.itemSearchGui = null;
        }
        if (this.fluidSearchGui != null && this.fluidSearchGui.getFilter() != null) {
            this.updateFluidFilter(this.editingSlot, new FluidStack(this.fluidSearchGui.getFilter(), 1000));
            this.fluidSearchGui = null;
        }
        MutableComponent invisibleText = PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.invisible", new Object[0]);
        WidgetCheckBox invisible = new WidgetCheckBox(this.leftPos + this.imageWidth - 20 - this.font.width((FormattedText)invisibleText), this.topPos + 17, -12566464, (Component)invisibleText, b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setSemiblockInvisible(b.checked);
            this.syncToServer();
        }).setChecked(((AbstractLogisticsFrameEntity)this.logistics).isSemiblockInvisible());
        this.addRenderableWidget((GuiEventListener)invisible);
        invisible.setTooltipKey("pneumaticcraft.gui.logistics_frame.invisible.tooltip");
        this.itemWhitelist = new WidgetButtonExtended(this.leftPos + 5, this.topPos + 16, 12, 12, (Component)Component.empty(), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setItemWhiteList(!((AbstractLogisticsFrameEntity)this.logistics).isItemWhiteList());
            this.updateLabels();
            this.syncToServer();
        }).setVisible(false).setInvisibleHoverColor(-2139062144);
        ((WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)this.itemWhitelist)).setTooltipKey("pneumaticcraft.gui.logistics_frame.itemWhitelist.tooltip");
        this.itemWhitelist.visible = ((AbstractLogisticsFrameEntity)this.logistics).supportsBlacklisting();
        this.fluidWhitelist = new WidgetButtonExtended(this.leftPos + 5, this.topPos + 88, 12, 12, (Component)Component.empty(), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setFluidWhiteList(!((AbstractLogisticsFrameEntity)this.logistics).isFluidWhiteList());
            this.updateLabels();
            this.syncToServer();
        }).setVisible(false).setInvisibleHoverColor(-2139062144);
        ((WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)this.fluidWhitelist)).setTooltipKey("pneumaticcraft.gui.logistics_frame.fluidWhitelist.tooltip");
        this.fluidWhitelist.visible = ((AbstractLogisticsFrameEntity)this.logistics).supportsBlacklisting();
        int xOff = ((AbstractLogisticsFrameEntity)this.logistics).supportsBlacklisting() ? 13 : 0;
        this.itemLabel = new WidgetLabel(this.leftPos + 5 + xOff, this.topPos + 18, (Component)Component.empty()){

            public void onClick(double mouseX, double mouseY, int button) {
                if (AbstractLogisticsScreen.this.itemWhitelist.visible) {
                    AbstractLogisticsScreen.this.itemWhitelist.onClick(mouseX, mouseY, button);
                }
            }
        };
        this.addRenderableWidget((GuiEventListener)this.itemLabel);
        this.fluidLabel = new WidgetLabel(this.leftPos + 5 + xOff, this.topPos + 90, (Component)Component.empty()){

            public void onClick(double mouseX, double mouseY, int button) {
                if (AbstractLogisticsScreen.this.fluidWhitelist.visible) {
                    AbstractLogisticsScreen.this.fluidWhitelist.onClick(mouseX, mouseY, button);
                }
            }
        };
        this.addRenderableWidget((GuiEventListener)this.fluidLabel);
        this.updateLabels();
        this.fluidWidgets.clear();
        IntStream.range(0, 9).forEach(i -> {
            FluidStack stack = ((AbstractLogisticsFrameEntity)this.logistics).getFluidFilter(i);
            PointXY p = this.getFluidSlotPos(i);
            WidgetFluidStack widgetFluidStack = new WidgetFluidStack(p.x(), p.y(), stack.copy(), b -> this.fluidClicked((WidgetFluidStack)((Object)((Object)b)), i));
            if (this.logistics instanceof LogisticsRequesterEntity) {
                widgetFluidStack.setAdjustable();
            }
            this.fluidWidgets.add(widgetFluidStack);
        });
        this.fluidWidgets.forEach(x$0 -> {
            WidgetFluidStack cfr_ignored_0 = (WidgetFluidStack)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.addInfoTab(GuiUtils.xlateAndSplit("gui.tooltip.item.pneumaticcraft." + ((AbstractSemiblockEntity)this.logistics).getSemiblockId().getPath(), new Object[0]));
        this.addFilterTab();
        this.addJeiFilterInfoTab();
        if (this.logistics instanceof ISpecificRequester) {
            this.addMinOrderSizeTab();
        }
    }

    private void addMinOrderSizeTab() {
        WidgetAnimatedStat minAmountStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_amount", new Object[0]), new ItemStack((ItemLike)Blocks.CHEST), -4145024, false);
        WidgetLabel minItemsLabel = new WidgetLabel(5, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_items", new Object[0]));
        minItemsLabel.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_items.tooltip", new Object[0]));
        minAmountStat.addSubWidget(minItemsLabel);
        this.minItemsField = new WidgetTextFieldNumber(this.font, 5, 30, 30, 12).setRange(1, 64).setAdjustments(1.0, 10.0).setValue(((ISpecificRequester)this.logistics).getMinItemOrderSize());
        this.minItemsField.setResponder(s -> this.sendDelayed(8));
        minAmountStat.addSubWidget((AbstractWidget)this.minItemsField);
        WidgetLabel minFluidLabel = new WidgetLabel(5, 47, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_fluid", new Object[0]));
        minFluidLabel.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_fluid.tooltip", new Object[0]));
        minAmountStat.addSubWidget(minFluidLabel);
        this.minFluidField = new WidgetTextFieldNumber(this.font, 5, 57, 50, 12).setRange(1, 16000).setAdjustments(100.0, 1000.0).setValue(((ISpecificRequester)this.logistics).getMinFluidOrderSize());
        this.minFluidField.setResponder(s -> this.sendDelayed(8));
        minAmountStat.addSubWidget((AbstractWidget)this.minFluidField);
        int w = Math.max(minItemsLabel.getWidth(), minFluidLabel.getWidth());
        minAmountStat.setMinimumExpandedDimensions(w, 75);
    }

    @Override
    protected void doDelayedAction() {
        L l = this.logistics;
        if (l instanceof ISpecificRequester) {
            ISpecificRequester s = (ISpecificRequester)l;
            s.setMinItemOrderSize(this.minItemsField.getIntValue());
            s.setMinFluidOrderSize(this.minFluidField.getIntValue());
            this.syncToServer();
        }
    }

    public void updateItemFilter(int slot, ItemStack stack) {
        ((LogisticsMenu)this.menu).getSlot(slot).set(stack);
        ((AbstractLogisticsFrameEntity)this.logistics).setItemFilter(slot, stack);
        this.syncToServer();
    }

    public void updateFluidFilter(int slot, FluidStack stack) {
        ((AbstractLogisticsFrameEntity)this.logistics).setFluidFilter(slot, stack);
        if (!this.fluidWidgets.isEmpty()) {
            this.fluidWidgets.get(slot).setFluidStack(stack);
        }
        this.syncToServer();
    }

    public PointXY getFluidSlotPos(int slot) {
        return new PointXY(this.leftPos + slot * 18 + 8, this.topPos + 101);
    }

    protected void updateLabels() {
        this.itemLabel.setMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame." + (((AbstractLogisticsFrameEntity)this.logistics).isItemWhiteList() ? "itemWhitelist" : "itemBlacklist"), new Object[0]));
        this.fluidLabel.setMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame." + (((AbstractLogisticsFrameEntity)this.logistics).isFluidWhiteList() ? "fluidWhitelist" : "fluidBlacklist"), new Object[0]));
        this.itemWhitelist.setRenderedIcon(((AbstractLogisticsFrameEntity)this.logistics).isItemWhiteList() ? Textures.GUI_WHITELIST : Textures.GUI_BLACKLIST);
        this.fluidWhitelist.setRenderedIcon(((AbstractLogisticsFrameEntity)this.logistics).isFluidWhiteList() ? Textures.GUI_WHITELIST : Textures.GUI_BLACKLIST);
    }

    private void syncToServer() {
        NetworkHandler.sendToServer(PacketSyncSemiblock.create(this.logistics, ((LogisticsMenu)this.menu).isItemContainer(), this.registryAccess()));
    }

    private void fluidClicked(WidgetFluidStack widget, int idx) {
        FluidStack stack = ((AbstractLogisticsFrameEntity)this.logistics).getFluidFilter(idx);
        if (!stack.isEmpty()) {
            ((AbstractLogisticsFrameEntity)this.logistics).setFluidFilter(idx, widget.getFluidStack().copy());
            this.syncToServer();
            return;
        }
        if (IOHelper.getFluidHandlerForItem(((LogisticsMenu)this.menu).getCarried()).isPresent()) {
            FluidStack f = IOHelper.getFluidHandlerForItem(((LogisticsMenu)this.menu).getCarried()).orElseThrow().getFluidInTank(0);
            ((AbstractLogisticsFrameEntity)this.logistics).setFluidFilter(idx, f.isEmpty() ? FluidStack.EMPTY : f.copyWithAmount(1000));
            widget.setFluid(f.getFluid());
            this.syncToServer();
            return;
        }
        this.fluidSearchGui = new LogisticsLiquidFilterScreen((Screen)this);
        this.editingSlot = idx;
        this.minecraft.setScreen((Screen)this.fluidSearchGui);
    }

    private void addFilterTab() {
        WidgetAnimatedStat filterTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.filter_settings", new Object[0]), PneumaticRegistry.RL("textures/gui/icon/gui_filter.png"), -15704048, false);
        filterTab.setMinimumExpandedDimensions(80, 65);
        WidgetCheckBox matchDurability = ((WidgetCheckBox)new WidgetCheckBox(5, 20, -1, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchDurability", new Object[0]), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setMatchDurability(b.checked);
            this.syncToServer();
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchDurability.tooltip")).setChecked(((AbstractLogisticsFrameEntity)this.logistics).isMatchDurability());
        filterTab.addSubWidget(matchDurability);
        WidgetCheckBox matchComponents = ((WidgetCheckBox)new WidgetCheckBox(5, 36, -1, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchComponents", new Object[0]), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setMatchComponents(b.checked);
            this.syncToServer();
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchComponents.tooltip")).setChecked(((AbstractLogisticsFrameEntity)this.logistics).isMatchComponents());
        filterTab.addSubWidget(matchComponents);
        WidgetCheckBox matchModId = ((WidgetCheckBox)new WidgetCheckBox(5, 52, -1, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchModId", new Object[0]), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setMatchModId(b.checked);
            this.syncToServer();
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchModId.tooltip")).setChecked(((AbstractLogisticsFrameEntity)this.logistics).isMatchModId());
        filterTab.addSubWidget(matchModId);
    }

    @Override
    protected OptionalInt getBackgroundTint() {
        if (!((Boolean)ConfigHelper.client().general.logisticsGuiTint.get()).booleanValue()) {
            return super.getBackgroundTint();
        }
        int c = ((AbstractLogisticsFrameEntity)this.logistics).getColor();
        float[] hsb = TintColor.RGBtoHSB((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF, null);
        TintColor color = TintColor.getHSBColor(hsb[0], hsb[1] * 0.2f, hsb[2]);
        if ((double)hsb[2] < 0.7) {
            color = color.brighter();
        }
        return OptionalInt.of(color.getARGB());
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LOGISTICS_REQUESTER;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected void slotClicked(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        if (slot instanceof PhantomSlot && ((LogisticsMenu)this.menu).getCarried().isEmpty() && !slot.hasItem() && (clickedButton == 0 || clickedButton == 1)) {
            this.editingSlot = slot.getSlotIndex();
            ClientUtils.openContainerGui(ModMenuTypes.ITEM_SEARCHER.get(), (Component)Component.literal((String)"Searcher"));
            if (this.minecraft.screen instanceof ItemSearcherScreen) {
                this.itemSearchGui = (ItemSearcherScreen)this.minecraft.screen;
            }
        } else {
            super.slotClicked(slot, slotId, clickedButton, clickType);
        }
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        Slot slot = this.findSlot(pMouseX, pMouseY);
        if (slot != null) {
            if (pScrollY > 0.0) {
                if (Screen.hasShiftDown()) {
                    this.slotClicked(slot, slot.index, 1, ClickType.QUICK_MOVE);
                } else {
                    this.slotClicked(slot, slot.index, 1, ClickType.PICKUP);
                }
            } else if (pScrollY < 0.0) {
                if (Screen.hasShiftDown()) {
                    this.slotClicked(slot, slot.index, 0, ClickType.QUICK_MOVE);
                } else {
                    this.slotClicked(slot, slot.index, 0, ClickType.PICKUP);
                }
            }
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    private Slot findSlot(double pMouseX, double pMouseY) {
        return ((LogisticsMenu)this.menu).slots.stream().filter(slot -> this.isHovering(slot.x, slot.y, 16, 16, pMouseX, pMouseY) && slot.isActive()).findFirst().orElse(null);
    }
}

