/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class WidgetTemperature
extends AbstractWidget {
    private int temperature;
    private int tickInterval;
    private final Supplier<List<Component>> tooltipSupplier;
    private TemperatureRange totalRange;
    private TemperatureRange operatingRange;
    private boolean drawText = true;
    private boolean showOperatingRange = true;

    public WidgetTemperature(int xIn, int yIn, TemperatureRange totalRange, int initialTemp, int tickInterval) {
        this(xIn, yIn, totalRange, initialTemp, tickInterval, null);
    }

    public WidgetTemperature(int xIn, int yIn, TemperatureRange totalRange, int initialTemp, int tickInterval, Supplier<List<Component>> tooltipSupplier) {
        super(xIn, yIn, 13, 50, (Component)Component.empty());
        this.totalRange = totalRange;
        this.temperature = initialTemp;
        this.tickInterval = tickInterval;
        this.tooltipSupplier = tooltipSupplier == null ? this::defaultTooltip : tooltipSupplier;
        this.operatingRange = null;
    }

    public void setTotalRange(@Nonnull TemperatureRange totalRange) {
        this.totalRange = totalRange;
    }

    public TemperatureRange getTotalRange() {
        return this.totalRange;
    }

    public WidgetTemperature setOperatingRange(@Nullable TemperatureRange operatingRange) {
        this.operatingRange = operatingRange;
        return this;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }

    public <T extends WidgetTemperature> T setDrawText(boolean drawText) {
        this.drawText = drawText;
        return (T)((Object)this);
    }

    public WidgetTemperature setShowOperatingRange(boolean showOperatingRange) {
        this.showOperatingRange = showOperatingRange;
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            graphics.blit(Textures.WIDGET_TEMPERATURE, x + 6, y, 6.0f, 0.0f, 7, 50, 18, 50);
            int barLength = this.getYPos(this.temperature);
            graphics.blit(Textures.WIDGET_TEMPERATURE, x + 7, y - 1 + this.height - barLength, 13.0f, (float)(this.height - barLength - 2), 5, barLength, 18, 50);
            this.drawTicks(graphics);
            if (this.drawText) {
                GuiUtils.drawScaledText(graphics, Minecraft.getInstance().font, (Component)Component.literal((String)TemperatureRange.TemperatureScale.CELSIUS.symbol()), x + 7, y + this.height + 1, -12566464, 0.5f, false);
            }
            this.drawOperatingTempMarkers(graphics);
            if (this.isHovered) {
                graphics.renderTooltip(Minecraft.getInstance().font, this.tooltipSupplier.get(), Optional.empty(), mouseX, mouseY);
            }
        }
    }

    private List<Component> defaultTooltip() {
        MutableComponent c = HeatUtil.formatHeatString(this.temperature).copy();
        if (this.operatingRange != null && this.showOperatingRange) {
            ChatFormatting tf = this.operatingRange.inRange(this.temperature) ? ChatFormatting.GREEN : ChatFormatting.GOLD;
            return List.of(c, PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.requiredTemperatureString", this.operatingRange.asString(TemperatureRange.TemperatureScale.CELSIUS)).withStyle(tf));
        }
        return List.of(c);
    }

    public void drawTicks(GuiGraphics graphics) {
        Font font = Minecraft.getInstance().font;
        int n = 0;
        int x = this.getX();
        int y = this.getY();
        for (int tickTempC = WidgetTemperature.findNearestCelsius(this.totalRange.getMin() - 273, this.tickInterval); tickTempC <= this.totalRange.getMax() - 273; tickTempC += this.tickInterval) {
            int yOffset = this.getYPos(tickTempC + 273);
            graphics.hLine(x + 4, x + 6, y - 1 + this.height - yOffset, -1606401984);
            if (yOffset != 0 && yOffset != this.height - 1) {
                graphics.hLine(x + 6, x + 8, y - 1 + this.height - yOffset, -2134851392);
            }
            if (this.drawText && n % 2 == 0) {
                MutableComponent s = Component.literal((String)Integer.toString(tickTempC));
                GuiUtils.drawScaledText(graphics, font, (Component)s, x + 4 - font.width((FormattedText)s) / 2, y - 2 + this.height - yOffset, -12566464, 0.5f, false);
            }
            ++n;
        }
    }

    public void drawOperatingTempMarkers(GuiGraphics graphics) {
        if (this.operatingRange != null) {
            int yOffset;
            int x = this.getX();
            int y = this.getY();
            if (this.totalRange.inRange(this.operatingRange.getMax())) {
                yOffset = this.getYPos(this.operatingRange.getMax());
                graphics.hLine(x + 7, x + 11, y + 1 + this.height - yOffset, -2039744);
                graphics.hLine(x + 9, x + 9, y + this.height - yOffset, -2132746176);
                graphics.hLine(x + 8, x + 10, y - 1 + this.height - yOffset, -2132746176);
                graphics.hLine(x + 7, x + 11, y - 2 + this.height - yOffset, -2132746176);
            }
            if (this.totalRange.inRange(this.operatingRange.getMin())) {
                yOffset = this.getYPos(this.operatingRange.getMin());
                graphics.hLine(x + 7, x + 11, y - 1 + this.height - yOffset, -2039744);
                graphics.hLine(x + 9, x + 9, y + this.height - yOffset, -2132746176);
                graphics.hLine(x + 8, x + 10, y + 1 + this.height - yOffset, -2132746176);
                graphics.hLine(x + 7, x + 11, y + 2 + this.height - yOffset, -2132746176);
            }
        }
    }

    private int getYPos(int temp) {
        int h = this.height - 1;
        return Mth.clamp((int)((temp - this.totalRange.getMin()) * h / (this.totalRange.getMax() - this.totalRange.getMin())), (int)0, (int)(h + 4));
    }

    private static int findNearestCelsius(int temp, int interval) {
        int q = temp % interval;
        if (q == 0) {
            return temp;
        }
        int n = temp - q;
        return Math.max(-273, n - interval);
    }

    public void autoScaleForTemperature() {
        if (this.temperature < 173) {
            this.setTotalRange(TemperatureRange.of(0, 275));
            this.setTickInterval(25);
        } else if (this.temperature < 273) {
            this.setTotalRange(TemperatureRange.of(123, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 373) {
            this.setTotalRange(TemperatureRange.of(273, 373));
            this.setTickInterval(25);
        } else if (this.temperature < 473) {
            this.setTotalRange(TemperatureRange.of(273, 473));
            this.setTickInterval(25);
        } else if (this.temperature < 773) {
            this.setTotalRange(TemperatureRange.of(273, 773));
            this.setTickInterval(50);
        } else if (this.temperature < 1273) {
            this.setTotalRange(TemperatureRange.of(273, 1273));
            this.setTickInterval(100);
        } else {
            this.setTotalRange(TemperatureRange.of(273, 2273));
            this.setTickInterval(200);
        }
    }

    public static int roundDownK(int tempK, int interval) {
        int tempC = tempK - 273;
        int rem = tempC % interval;
        return tempK - rem;
    }

    public static int roundUpK(int tempK, int interval) {
        return WidgetTemperature.roundDownK(tempK, interval) + interval;
    }

    public static WidgetTemperature fromOperatingRange(int x, int y, TemperatureRange range) {
        TemperatureRange totalRange;
        int interval = WidgetTemperature.calcInterval(range.getMax() - range.getMin());
        if (range.hasMin() && range.hasMax()) {
            totalRange = TemperatureRange.of(WidgetTemperature.roundDownK(range.getMin(), interval), WidgetTemperature.roundUpK(range.getMax(), interval));
        } else if (range.hasMin()) {
            int minK = WidgetTemperature.roundDownK(range.getMin(), interval);
            totalRange = TemperatureRange.of(minK, minK + interval * 2);
        } else {
            totalRange = range.hasMax() ? TemperatureRange.of(0, WidgetTemperature.roundUpK(range.getMax(), interval)) : TemperatureRange.of(0, 2273);
        }
        interval = WidgetTemperature.calcInterval(totalRange.getMax() - totalRange.getMin()) * 2;
        return new WidgetTemperature(x, y, totalRange, range.getMin(), interval).setOperatingRange(range);
    }

    public static int calcInterval(int r) {
        int r1 = r / 10;
        if (r1 >= 200) {
            return 200;
        }
        if (r1 >= 100) {
            return 100;
        }
        if (r1 >= 50) {
            return 50;
        }
        if (r1 >= 15) {
            return 25;
        }
        if (r1 >= 5) {
            return 10;
        }
        return 5;
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

