/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.common.entity.semiblock.SpawnerAgitatorEntity;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.BaseSpawnerAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTrackEntryMobSpawner
implements IBlockTrackEntry {
    public static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.spawner");

    @Override
    public boolean shouldTrackWithThisEntry(Level world, BlockPos pos, BlockState state, BlockEntity te) {
        return state.getBlock() == Blocks.SPAWNER;
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(BlockEntity te) {
        return te == null ? Collections.emptyList() : Collections.singletonList(te.getBlockPos());
    }

    @Override
    public int spamThreshold() {
        return 10;
    }

    @Override
    public void addInformation(Level world, BlockPos pos, BlockEntity te, Direction face, List<Component> infoList) {
        if (te instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)te;
            BaseSpawner spawner = spawnerBlockEntity.getSpawner();
            Entity e = spawner.getOrCreateDisplayEntity(world, spawnerBlockEntity.getBlockPos());
            if (e == null) {
                infoList.add((Component)Component.literal((String)"<ERROR> Missing entity?"));
                return;
            }
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.type", e.getName().getString()));
            if (this.isNearPlayer(spawner, world, pos) || this.hasAgitator(world, pos)) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.time", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((BaseSpawnerAccess)spawner).getSpawnDelay(), false)));
            } else if (HackableMobSpawner.isHacked((BlockGetter)world, pos)) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.hacked", new Object[0]));
            } else {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.standby", new Object[0]));
            }
        }
    }

    private boolean isNearPlayer(BaseSpawner spawner, Level pLevel, BlockPos pPos) {
        return pLevel.hasNearbyAlivePlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, (double)((BaseSpawnerAccess)spawner).getRequiredPlayerRange());
    }

    private boolean hasAgitator(Level world, BlockPos pos) {
        return SemiblockTracker.getInstance().getSemiblock(world, pos) instanceof SpawnerAgitatorEntity;
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }
}

