/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.IHasBoundingBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPNCBlockWithBoundingBlocks
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    public static final BooleanProperty BOUNDING = BooleanProperty.create((String)"bounding");

    public AbstractPNCBlockWithBoundingBlocks(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BOUNDING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.getValue((Property)BOUNDING) != false ? Shapes.empty() : ALMOST_FULL_SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BOUNDING});
    }

    @Nonnull
    public abstract Vec3i[] getBoundingBlockOffsets();

    public BlockPos getMainPos(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos;
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)BOUNDING)).booleanValue() && (blockEntity = world.getBlockEntity(pos)) instanceof IHasBoundingBlocks) {
            IHasBoundingBlocks bounding = (IHasBoundingBlocks)blockEntity;
            blockPos = pos.subtract(bounding.getOffsetFromMain());
        } else {
            blockPos = pos;
        }
        return blockPos;
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        IHasBoundingBlocks blockEntity;
        if (((Boolean)state.getValue((Property)BOUNDING)).booleanValue()) {
            return world.getBlockState(this.getMainPos(state, world, pos)).getBlock() == state.getBlock();
        }
        Vec3i[] vec3iArray = world.getBlockEntity(pos);
        if (vec3iArray instanceof IHasBoundingBlocks && (blockEntity = (IHasBoundingBlocks)vec3iArray).getBoundingPlaced()) {
            for (Vec3i offset : this.getBoundingBlockOffsets()) {
                if (!world.isEmptyBlock(pos.offset(offset))) continue;
                return false;
            }
        } else {
            for (Vec3i offset : this.getBoundingBlockOffsets()) {
                if (world.isEmptyBlock(pos.offset(offset))) continue;
                return false;
            }
        }
        return true;
    }

    private void removeBoundingBlocks(BlockState state, Level level, BlockPos mainPos, @Nullable Player player) {
        Object blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(mainPos);
        if (blockEntity2 instanceof IHasBoundingBlocks) {
            blockEntity = (Vec3i[])blockEntity2;
            blockEntity.setMainBlockRemovalLock(true);
        }
        for (Vec3i offset : this.getBoundingBlockOffsets()) {
            BlockPos offsetPos = mainPos.offset(offset);
            if (level.getBlockState(offsetPos).getBlock() != this) continue;
            if (player != null) {
                this.spawnDestroyParticles(level, player, offsetPos, state);
            }
            level.removeBlock(offsetPos, false);
        }
        BlockEntity blockEntity3 = level.getBlockEntity(mainPos);
        if (blockEntity3 instanceof IHasBoundingBlocks) {
            blockEntity = (IHasBoundingBlocks)blockEntity3;
            blockEntity.setBoundingRemoved(true);
            blockEntity.setMainBlockRemovalLock(false);
        }
    }

    private void placeBoundingBlocks(Level level, BlockPos mainPos) {
        for (Vec3i offset : this.getBoundingBlockOffsets()) {
            level.setBlock(mainPos.offset(offset), (BlockState)level.getBlockState(mainPos).setValue((Property)BOUNDING, (Comparable)Boolean.valueOf(true)), 3);
            BlockEntity blockEntity = level.getBlockEntity(mainPos.offset(offset));
            if (!(blockEntity instanceof IHasBoundingBlocks)) continue;
            IHasBoundingBlocks blockEntity2 = (IHasBoundingBlocks)blockEntity;
            blockEntity2.setOffsetFromMain(offset);
        }
        BlockEntity blockEntity = level.getBlockEntity(mainPos);
        if (blockEntity instanceof IHasBoundingBlocks) {
            IHasBoundingBlocks blockEntity3 = (IHasBoundingBlocks)blockEntity;
            blockEntity3.setBoundingPlaced(true);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockPos mainPos = this.getMainPos(state, (LevelReader)level, pos);
        if (!pos.equals((Object)mainPos)) {
            BlockState mainBlockState = level.getBlockState(mainPos);
            this.onDestroyedByPlayer(mainBlockState, level, mainPos, player, willHarvest, mainBlockState.getFluidState());
            return false;
        }
        this.removeBoundingBlocks(state, level, pos, player);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public void setRotation(Level world, BlockPos pos, Direction rotation) {
        BlockEntity blockEntity;
        if (!((Boolean)world.getBlockState(pos).getValue((Property)BOUNDING)).booleanValue() && (blockEntity = world.getBlockEntity(pos)) instanceof IHasBoundingBlocks) {
            IHasBoundingBlocks blockEntity2 = (IHasBoundingBlocks)blockEntity;
            blockEntity2.setMainBlockRemovalLock(true);
            super.setRotation(world, pos, rotation);
            blockEntity2.setMainBlockRemovalLock(false);
        }
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        BlockState state = world.getBlockState(pos);
        BlockPos mainPos = this.getMainPos(state, (LevelReader)world, pos);
        if (!pos.equals((Object)mainPos)) {
            return this.onWrenched(world, player, this.getMainPos(state, (LevelReader)world, pos), face, hand);
        }
        if (player != null && player.isShiftKeyDown()) {
            this.removeBoundingBlocks(state, world, pos, null);
        }
        return super.onWrenched(world, player, pos, face, hand);
    }

    public void onPlace(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!((Boolean)pState.getValue((Property)BOUNDING)).booleanValue()) {
            this.placeBoundingBlocks(pLevel, pPos);
        }
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        IHasBoundingBlocks blockEntity;
        BlockEntity blockEntity2;
        if (!((Boolean)state.getValue((Property)BOUNDING)).booleanValue() && (blockEntity2 = world.getBlockEntity(pos)) instanceof IHasBoundingBlocks && !(blockEntity = (IHasBoundingBlocks)blockEntity2).getBoundingRemoved()) {
            this.removeBoundingBlocks(state, world, pos, null);
        } else {
            IHasBoundingBlocks blockEntity3;
            blockEntity2 = world.getBlockEntity(this.getMainPos(state, (LevelReader)world, pos));
            if (blockEntity2 instanceof IHasBoundingBlocks && !(blockEntity3 = (IHasBoundingBlocks)blockEntity2).getMainBlockRemovalLock()) {
                world.removeBlock(this.getMainPos(state, (LevelReader)world, pos), false);
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult brtr) {
        return (Boolean)state.getValue((Property)BOUNDING) != false ? InteractionResult.FAIL : super.useWithoutItem(state, world, pos, player, brtr);
    }
}

