/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public interface IAutoFluidEjecting {
    default public void autoExportFluid(AbstractPneumaticCraftBlockEntity te) {
        IOHelper.getFluidHandlerForBlock(te).ifPresent(handler -> {
            FluidStack toDrain = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!toDrain.isEmpty()) {
                te.getUpgradeCache().getEjectDirection().ifPresentOrElse(ejectDir -> this.tryEjectLiquid(te, (IFluidHandler)handler, (Direction)ejectDir, toDrain.getAmount()), () -> {
                    for (Direction d : DirectionUtil.VALUES) {
                        toDrain.setAmount(toDrain.getAmount() - this.tryEjectLiquid(te, (IFluidHandler)handler, d, toDrain.getAmount()));
                        if (toDrain.getAmount() <= 0) break;
                    }
                });
            }
        });
    }

    default public int tryEjectLiquid(AbstractPneumaticCraftBlockEntity te, IFluidHandler handler, Direction dir, int amount) {
        BlockEntity teNeighbour = te.getCachedNeighbor(dir);
        if (teNeighbour != null) {
            return IOHelper.getFluidHandlerForBlock(teNeighbour, dir.getOpposite()).map(destHandler -> {
                FluidStack fluidStack = FluidUtil.tryFluidTransfer((IFluidHandler)destHandler, (IFluidHandler)handler, (int)amount, (boolean)true);
                return fluidStack.getAmount();
            }).orElse(0);
        }
        return 0;
    }
}

