/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

@FunctionalInterface
public interface ISerializableTanks {
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks();

    default public void deserializeTanks(HolderLookup.Provider provider, CompoundTag tag) {
        this.getSerializableTanks().forEach((comp, tank) -> tank.readFromNBT(provider, tag.getCompound(comp.toString())));
    }

    default public CompoundTag serializeTanks(HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> this.getSerializableTanks().forEach((comp, tank) -> {
            if (!tank.getFluid().isEmpty()) {
                tag.put(comp.toString(), tank.writeToNBT(provider));
            }
        }));
    }
}

