/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.AphorismTileBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class AphorismTileBlockEntity
extends AbstractPneumaticCraftBlockEntity {
    private static final Pattern ITEM_PAT = Pattern.compile("^\\{item:(\\w+:[a-z0-9_.]+)}$");
    private String[] textLines = new String[]{""};
    private ItemStack[] icons = new ItemStack[]{ItemStack.EMPTY};
    private BitSet rsLines = new BitSet(1);
    private int textRotation;
    private int borderColor = DyeColor.BLUE.getId();
    private int backgroundColor = DyeColor.WHITE.getId();
    private int maxLineWidth = -1;
    private byte marginSize;
    private boolean invisible;
    public int currentRedstonePower = 0;
    private long lastPoll = 0L;
    public int cursorX = -1;
    public int cursorY = -1;

    public AphorismTileBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.APHORISM_TILE.get(), pos, state);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    public void loadSavedData(SavedData savedData) {
        if (savedData != null) {
            this.textLines = savedData.lines.toArray(new String[0]);
            this.textRotation = savedData.rotation;
            this.borderColor = savedData.borderColor;
            this.backgroundColor = savedData.bgColor;
            this.marginSize = (byte)savedData.margin;
            this.invisible = savedData.invisible;
            this.updateLineMetadata();
        }
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        SavedData savedData = (SavedData)componentInput.get(ModDataComponents.APHORISM_TILE_DATA);
        this.loadSavedData(savedData);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ModDataComponents.APHORISM_TILE_DATA, (Object)SavedData.forTile(this));
    }

    @Override
    public void writeToPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeToPacket(tag, provider);
        SavedData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)SavedData.forTile(this)).ifSuccess(subTag -> tag.put("AphorismData", subTag));
    }

    @Override
    public void readFromPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.readFromPacket(tag, provider);
        if (tag.contains("AphorismData")) {
            SavedData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("AphorismData")).ifSuccess(savedData -> {
                this.loadSavedData((SavedData)savedData);
                if (this.level != null) {
                    this.forceBlockEntityRerender();
                }
                this.maxLineWidth = -1;
            });
        }
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public void setTextLines(String[] textLines) {
        String[] stringArray;
        if (textLines.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = textLines;
        }
        this.setTextLines(stringArray, true);
    }

    public int getTextRotation() {
        return this.textRotation;
    }

    public void setTextRotation(int textRotation) {
        this.textRotation = textRotation;
    }

    public void setTextLines(String[] textLines, boolean notifyClient) {
        this.textLines = textLines;
        this.maxLineWidth = -1;
        this.icons = new ItemStack[textLines.length];
        if (this.level != null) {
            if (this.level.isClientSide) {
                this.updateLineMetadata();
            } else if (notifyClient) {
                this.sendDescriptionPacket();
            }
        }
        this.setChanged();
    }

    private void updateLineMetadata() {
        this.icons = new ItemStack[this.textLines.length];
        this.rsLines = new BitSet(this.textLines.length);
        for (int i = 0; i < this.textLines.length; ++i) {
            Matcher m = ITEM_PAT.matcher(this.textLines[i]);
            if (m.matches()) {
                this.icons[i] = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)m.group(1))));
                continue;
            }
            this.icons[i] = ItemStack.EMPTY;
            if (!this.textLines[i].contains("{redstone}")) continue;
            this.rsLines.set(i);
        }
    }

    public ItemStack getIconAt(int line) {
        return line >= 0 && line < this.icons.length ? this.icons[line] : ItemStack.EMPTY;
    }

    public boolean isRedstoneLine(int line) {
        return line >= 0 && line < this.rsLines.size() && this.rsLines.get(line);
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
        if (!this.nonNullLevel().isClientSide) {
            this.sendDescriptionPacket();
        }
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        if (!this.nonNullLevel().isClientSide) {
            this.sendDescriptionPacket();
        }
        this.setChanged();
    }

    public byte getMarginSize() {
        return this.marginSize;
    }

    public void setMarginSize(int marginSize) {
        this.marginSize = (byte)Mth.clamp((int)marginSize, (int)0, (int)9);
        this.needMaxLineWidthRecalc();
        this.setChanged();
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        BlockState state;
        this.invisible = invisible;
        if (this.level != null && (state = this.getBlockState()).getBlock() instanceof AphorismTileBlock) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)AphorismTileBlock.INVISIBLE, (Comparable)Boolean.valueOf(invisible)));
        }
        this.setChanged();
    }

    public int getMaxLineWidth(boolean editing) {
        if (this.maxLineWidth < 0) {
            for (int i = 0; i < this.textLines.length; ++i) {
                int stringWidth;
                String line = this.textLines[i];
                if (!editing && this.isRedstoneLine(i)) {
                    line = line.replaceAll(Pattern.quote("{redstone}"), Integer.toString(this.currentRedstonePower));
                }
                int n = stringWidth = !editing && !this.getIconAt(i).isEmpty() ? 6 : ClientUtils.getStringWidth(line);
                if (stringWidth <= this.maxLineWidth) continue;
                this.maxLineWidth = stringWidth;
            }
            float mul = 1.0f + (float)(this.marginSize + 1) * 0.075f;
            this.maxLineWidth = (int)((float)this.maxLineWidth * mul);
        }
        return this.maxLineWidth;
    }

    public void needMaxLineWidthRecalc() {
        this.maxLineWidth = -1;
    }

    public int pollRedstone() {
        Level level = this.nonNullLevel();
        if (level.getGameTime() - this.lastPoll >= 2L) {
            Direction d = this.getRotation();
            int p = this.nonNullLevel().getSignal(this.worldPosition.relative(d), d);
            if (p != this.currentRedstonePower) {
                this.needMaxLineWidthRecalc();
            }
            this.currentRedstonePower = p;
            this.lastPoll = this.nonNullLevel().getGameTime();
        }
        return this.currentRedstonePower;
    }

    public Pair<Integer, Integer> getCursorPos() {
        int cy = this.cursorY >= 0 && this.cursorY < this.textLines.length ? this.cursorY : this.textLines.length - 1;
        int cx = this.cursorX >= 0 && this.cursorX <= this.textLines[cy].length() ? this.cursorX : this.textLines[cy].length();
        return Pair.of((Object)cx, (Object)cy);
    }

    public void setCursorPos(int cursorX, int cursorY) {
        this.cursorX = cursorX;
        this.cursorY = cursorY;
    }

    public record SavedData(List<String> lines, int rotation, int borderColor, int bgColor, int margin, boolean invisible) {
        public static final Codec<SavedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.listOf().fieldOf("lines").forGetter(SavedData::lines), (App)Codec.INT.fieldOf("rotation").forGetter(SavedData::rotation), (App)Codec.INT.fieldOf("border").forGetter(SavedData::borderColor), (App)Codec.INT.fieldOf("background").forGetter(SavedData::bgColor), (App)Codec.INT.fieldOf("margin").forGetter(SavedData::margin), (App)Codec.BOOL.fieldOf("invisible").forGetter(SavedData::invisible)).apply((Applicative)builder, SavedData::new));
        public static final StreamCodec<FriendlyByteBuf, SavedData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), SavedData::lines, (StreamCodec)ByteBufCodecs.INT, SavedData::rotation, (StreamCodec)ByteBufCodecs.INT, SavedData::borderColor, (StreamCodec)ByteBufCodecs.INT, SavedData::bgColor, (StreamCodec)ByteBufCodecs.VAR_INT, SavedData::margin, (StreamCodec)ByteBufCodecs.BOOL, SavedData::invisible, SavedData::new);

        static SavedData forTile(AphorismTileBlockEntity be) {
            return new SavedData(Arrays.asList(be.textLines), be.textRotation, be.borderColor, be.backgroundColor, be.marginSize, be.invisible);
        }
    }
}

