/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.config.subconfig.ProgWidgetConfig;
import me.desht.pneumaticcraft.common.config.subconfig.ThirdPartyConfig;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AuxConfigHandler {
    private static final LevelResource FOLDER = new LevelResource("pneumaticcraft");
    private static final IAuxConfig[] EXTERNAL_CONFIGS = new IAuxConfig[]{AmadronPlayerOffers.INSTANCE, ProgWidgetConfig.INSTANCE, ArmorFeatureStatus.INSTANCE, ThirdPartyConfig.INSTANCE, MicromissileDefaults.INSTANCE, ArmorHUDLayout.INSTANCE};

    public static void preInit() {
        File defaultConfigDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "pneumaticcraft");
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            if (subConfig.useWorldSpecificDir() || !defaultConfigDir.exists() && !defaultConfigDir.mkdirs()) continue;
            File subFile = new File(defaultConfigDir, subConfig.getConfigFilename() + ".cfg");
            try {
                subConfig.preInit(subFile);
            }
            catch (IOException e) {
                Log.error("Config file {} failed to create! Unexpected things can happen!", subConfig.getConfigFilename());
                Log.error("Error detail: " + e.getMessage(), new Object[0]);
            }
            catch (JsonSyntaxException | ClassCastException e) {
                Log.error("Config file {} appears to be invalid JSON! Unexpected things can happen!", subConfig.getConfigFilename());
                Log.error("Error detail: " + e.getMessage(), new Object[0]);
            }
        }
    }

    public static void postInit(IAuxConfig.Sidedness sidedness) {
        File defaultConfigDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "pneumaticcraft");
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            File subFolder;
            if (!subConfig.getSidedness().matches(sidedness) || subConfig.useWorldSpecificDir() && sidedness != IAuxConfig.Sidedness.SERVER) continue;
            File file = subFolder = subConfig.useWorldSpecificDir() ? AuxConfigHandler.getWorldSpecificDir() : defaultConfigDir;
            if (!subFolder.exists() && !subFolder.mkdirs()) continue;
            File subFile = new File(subFolder, subConfig.getConfigFilename() + ".cfg");
            try {
                subConfig.postInit(subFile);
            }
            catch (IOException e) {
                Log.error("Config file {} failed to create! Unexpected things can happen!", subConfig.getConfigFilename());
                Log.error("Error detail: " + e.getMessage(), new Object[0]);
            }
            catch (JsonSyntaxException | ClassCastException e) {
                Log.error("Config file {} appears to be invalid JSON! Unexpected things can happen!", subConfig.getConfigFilename());
                Log.error("Error detail: " + e.getMessage(), new Object[0]);
            }
        }
    }

    private static File getWorldSpecificDir() {
        return ServerLifecycleHooks.getCurrentServer().getWorldPath(FOLDER).toFile();
    }

    public static void clearPerWorldConfigs() {
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            if (!subConfig.useWorldSpecificDir()) continue;
            subConfig.clear();
        }
    }
}

