/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import me.desht.pneumaticcraft.api.drone.SpecialVariableRetrievalEvent;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

public class DroneSpecialVariableHandler {
    private static final Map<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>> DISPATCH_MAP = new HashMap<String, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos>>();
    private static final BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos> MISSING = (event, extraParam) -> BlockPos.ZERO;

    private static void register(String var, BiFunction<SpecialVariableRetrievalEvent.CoordinateVariable.Drone, String, BlockPos> func) {
        if (DISPATCH_MAP.containsKey(var)) {
            Log.warning("special variable '{}' is already registered! ignoring", new Object[0]);
        } else {
            DISPATCH_MAP.put(var, func);
        }
    }

    private static BlockPos getPosForPlayer(Player player) {
        return player == null ? BlockPos.ZERO : player.blockPosition().relative(Direction.UP);
    }

    private static BlockPos getPosForOtherPlayer(Player droneOwner, Player otherPlayer) {
        if (!((Boolean)ConfigHelper.common().drones.allowAnyPlayerVarQuery.get()).booleanValue() && droneOwner != otherPlayer) {
            return BlockPos.ZERO;
        }
        return DroneSpecialVariableHandler.getPosForPlayer(otherPlayer);
    }

    private static BlockPos getPlayerLookVec(Player player) {
        if (player == null) {
            return BlockPos.ZERO;
        }
        Direction d = player.getDirection();
        float pitch = player.getViewXRot(0.0f);
        int yDir = Math.abs(pitch) < 45.0f ? 0 : (int)Math.signum(-pitch);
        return new BlockPos(d.getStepX(), yDir, d.getStepZ());
    }

    @SubscribeEvent
    public void onSpecialVariableRetrieving(SpecialVariableRetrievalEvent.CoordinateVariable.Drone event) {
        String[] s = event.specialVarName.split("=", 2);
        String extra = s.length > 1 ? s[1] : "";
        event.setCoordinate(DISPATCH_MAP.getOrDefault(s[0], MISSING).apply(event, extra));
    }

    static {
        DroneSpecialVariableHandler.register("drone_pos", (event, extra) -> BlockPos.containing((Position)event.drone.getDronePos()));
        DroneSpecialVariableHandler.register("controller_pos", (event, extra) -> event.drone.getControllerPos());
        DroneSpecialVariableHandler.register("owner_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("player_pos", (event, extra) -> DroneSpecialVariableHandler.getPosForOtherPlayer(event.drone.getOwner(), (Player)PneumaticCraftUtils.getPlayerFromName(extra)));
        DroneSpecialVariableHandler.register("deploy_pos", (event, extra) -> event.drone.getDeployPos());
        DroneSpecialVariableHandler.register("owner_look", (event, extra) -> DroneSpecialVariableHandler.getPlayerLookVec(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("owner", (event, extra) -> DroneSpecialVariableHandler.getPosForPlayer(event.drone.getOwner()));
        DroneSpecialVariableHandler.register("player", (event, extra) -> DroneSpecialVariableHandler.getPosForOtherPlayer(event.drone.getOwner(), (Player)PneumaticCraftUtils.getPlayerFromName(extra)));
        DroneSpecialVariableHandler.register("drone", (event, extra) -> BlockPos.containing((Position)event.drone.getDronePos()).relative(Direction.UP));
    }
}

