/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.NodeProcessorDrone;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticleTrail;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class EntityPathNavigateDrone
extends FlyingPathNavigation
implements IPathNavigator {
    private final DroneEntity droneEntity;
    private boolean forceTeleport;
    private int teleportCounter = -1;
    private BlockPos telPos;
    private static final int TELEPORT_TICKS = 120;
    private int stuckTicks = 0;

    public EntityPathNavigateDrone(DroneEntity droneEntity, Level world) {
        super((Mob)droneEntity, world);
        this.droneEntity = droneEntity;
    }

    public boolean moveTo(Entity pEntity, double pSpeed) {
        return super.moveTo(pEntity, pSpeed) || this.isGoingToTeleport();
    }

    public void setForceTeleport(boolean forceTeleport) {
        this.forceTeleport = forceTeleport;
    }

    @Nullable
    public Path createPath(BlockPos pos, int pAccuracy) {
        Node lastPoint;
        Path path;
        if (pAccuracy == 0 && !this.droneEntity.isBlockValidPathfindBlock(pos)) {
            return this.createPath(pos, 1);
        }
        if (this.droneEntity.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) < 0.75) {
            return new Path((List)Lists.newArrayList((Object[])new Node[]{new Node(pos.getX(), pos.getY(), pos.getZ())}), pos, true);
        }
        this.telPos = pos;
        if (this.forceTeleport) {
            this.teleportCounter = 0;
            return null;
        }
        this.droneEntity.setStandby(false, false);
        boolean tallBlockKludge = false;
        BlockPos below = pos.below();
        VoxelShape shape = this.level.getBlockState(below).getCollisionShape((BlockGetter)this.level, below);
        if (!shape.isEmpty() && shape.bounds().maxY > 1.0) {
            path = super.createPath(pos, 1);
            tallBlockKludge = true;
        } else {
            path = super.createPath(pos, 0);
        }
        if (path != null && (lastPoint = path.getEndNode()) != null && pos.distManhattan((Vec3i)lastPoint.asBlockPos()) > pAccuracy + (tallBlockKludge ? 1 : 0)) {
            path = null;
        }
        if (path == null && this.teleportationAllowed(pos)) {
            if (this.teleportCounter == -1) {
                this.teleportCounter = 0;
            }
        } else {
            this.teleportCounter = -1;
        }
        return path;
    }

    private boolean teleportationAllowed(BlockPos pos) {
        if (!this.checkForChunkLoading(pos)) {
            return false;
        }
        boolean secStationProtected = (Boolean)ConfigHelper.common().drones.allowTeleportToProtectedArea.get() == false && SecurityStationBlockEntity.isProtectedFromPlayer(this.droneEntity.getOwnerUUID(), this.droneEntity.level(), pos, false);
        int max = (Integer)ConfigHelper.common().drones.maxDroneTeleportRange.get();
        return !secStationProtected && (!this.droneEntity.isTeleportRangeLimited() || max == 0 || pos.closerToCenterThan((Position)this.droneEntity.getDronePos(), (double)max));
    }

    @Override
    public boolean isGoingToTeleport() {
        return this.teleportCounter >= 0;
    }

    public boolean isDone() {
        return super.isDone() && !this.isGoingToTeleport();
    }

    public void tick() {
        ++this.tick;
        if (this.isGoingToTeleport()) {
            if (this.teleportCounter == 0 || this.teleportCounter == 60) {
                this.droneEntity.level().playSound(null, this.droneEntity.blockPosition(), (SoundEvent)ModSounds.TELEPORT_WARMUP.get(), SoundSource.NEUTRAL, 0.3f, this.teleportCounter == 0 ? 0.7f : 1.0f);
            }
            if (this.teleportCounter < 80) {
                RandomSource rand = this.droneEntity.getRandom();
                float f = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f1 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f2 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketSpawnParticle.oneParticle((ParticleOptions)ParticleTypes.PORTAL, this.droneEntity.position().toVector3f(), new Vector3f(f, f1, f2)), (Entity)this.droneEntity);
            }
            if (++this.teleportCounter > 120) {
                if (this.checkForChunkLoading(this.telPos) && this.droneEntity.isBlockValidPathfindBlock(this.telPos)) {
                    this.teleport();
                }
                this.teleportCounter = -1;
                this.moveTo((Path)null, 0.0);
                this.droneEntity.getMoveControl().setWantedPosition((double)this.telPos.getX(), (double)this.telPos.getY(), (double)this.telPos.getZ(), this.droneEntity.getDroneSpeed());
                this.droneEntity.addAirToDrone(-10000);
            }
        } else if (!this.isDone()) {
            this.followThePath();
            if (this.path != null && !this.path.isDone()) {
                if ((Integer)ConfigHelper.common().drones.stuckDroneTeleportTicks.get() > 0 && this.mob.getDeltaMovement().lengthSqr() < 1.0E-4) {
                    if (this.stuckTicks++ > (Integer)ConfigHelper.common().drones.stuckDroneTeleportTicks.get()) {
                        Vec3 v = this.droneEntity.getDronePos();
                        this.droneEntity.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.stuckBlock", BlockPos.containing((double)Math.round(v.x), (double)Math.round(v.y), (double)Math.round(v.z)));
                        this.teleportCounter = 0;
                        this.telPos = this.path.getTarget();
                        this.stuckTicks = 0;
                    }
                } else {
                    this.stuckTicks = 0;
                }
                if (!this.isDone()) {
                    Vec3 vec32 = this.path.getNextEntityPos((Entity)this.mob);
                    this.mob.getMoveControl().setWantedPosition(vec32.x, vec32.y, vec32.z, this.speedModifier);
                }
            }
        }
    }

    public void teleport() {
        Vec3 dest = Vec3.atCenterOf((Vec3i)this.telPos);
        NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketSpawnParticleTrail((ParticleOptions)ParticleTypes.PORTAL, this.droneEntity.position().toVector3f(), dest.toVector3f()), (Entity)this.droneEntity);
        this.droneEntity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        this.droneEntity.setPos(dest.x, dest.y, dest.z);
    }

    @Override
    public boolean moveToXYZ(double x, double y, double z) {
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        if (!this.checkForChunkLoading(pos)) {
            this.droneEntity.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.unloadedChunk", pos);
            return false;
        }
        boolean success = this.moveTo(x, y, z, this.droneEntity.getDroneSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    @Override
    public boolean moveToEntity(Entity entity) {
        boolean success = this.moveTo(entity, this.droneEntity.getDroneSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    private boolean checkForChunkLoading(BlockPos pos) {
        return (Boolean)ConfigHelper.common().drones.allowNavigateToUnloadedChunks.get() != false || this.level.isLoaded(pos);
    }

    public boolean moveTo(Path path, double speedIn) {
        if (path != null && !this.checkForChunkLoading(path.getTarget())) {
            this.droneEntity.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.unloadedChunk", path.getTarget());
            return false;
        }
        return super.moveTo(path, this.droneEntity.getDroneSpeed());
    }

    private void forceRidingEntityPaths() {
        for (Entity ridingEntity : this.droneEntity.getPassengers()) {
            if (!(ridingEntity instanceof Mob)) continue;
            Mob ridingLiving = (Mob)ridingEntity;
            ridingLiving.getNavigation().moveTo(this.droneEntity.getNavigation().getPath(), this.droneEntity.getDroneSpeed());
        }
    }

    @Override
    public boolean hasNoPath() {
        return this.isDone();
    }

    protected PathFinder createPathFinder(int r) {
        this.nodeEvaluator = new NodeProcessorDrone();
        return new PathFinder(this.nodeEvaluator, 1000);
    }

    protected Vec3 getTempMobPos() {
        return this.droneEntity.getDronePos();
    }

    protected boolean canUpdatePath() {
        return true;
    }
}

