/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.DroneSuicideEvent;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ProgWidgetSuicide
extends ProgWidget {
    public static final MapCodec<ProgWidgetSuicide> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetSuicide.baseParts(builder).apply((Applicative)builder, ProgWidgetSuicide::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetSuicide> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetSuicide::new);

    private ProgWidgetSuicide(ProgWidget.PositionFields pos) {
        super(pos);
    }

    public ProgWidgetSuicide() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetSuicide(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.SUICIDE.get();
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public boolean hasStepOutput() {
        return false;
    }

    @Override
    public int getWidth() {
        return 40;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.LIME;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_SUICIDE;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAISuicide(drone);
    }

    private static class DroneAISuicide
    extends Goal {
        private final IDrone drone;

        DroneAISuicide(IDrone drone) {
            this.drone = drone;
        }

        public boolean canUse() {
            NeoForge.EVENT_BUS.post((Event)new DroneSuicideEvent(this.drone));
            this.drone.overload("suicide", new Object[0]);
            return false;
        }
    }
}

