/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class AreaTypeWall
extends AreaType {
    public static final MapCodec<AreaTypeWall> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StringRepresentable.fromEnum(AreaType.AreaAxis::values).fieldOf("axis").forGetter(t -> t.axis)).apply((Applicative)builder, AreaTypeWall::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypeWall> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(AreaType.AreaAxis.class), t -> t.axis, AreaTypeWall::new);
    public static final String ID = "wall";
    private AreaType.AreaAxis axis;

    public AreaTypeWall() {
        this(AreaType.AreaAxis.X);
    }

    public AreaTypeWall(AreaType.AreaAxis axis) {
        super(ID);
        this.axis = axis;
    }

    @Override
    public AreaType copy() {
        return new AreaTypeWall(this.axis);
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.axis);
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_WALL.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                Vec3 lineVec = new Vec3(0.0, (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x, lineVec.y / 10.0, lineVec.z / 10.0);
                double curY = (double)p1.getY() + 0.5;
                double curZ = (double)p1.getZ() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.getY() - p2.getY(), 2.0) + Math.pow(p1.getZ() - p2.getZ(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curY += lineVec.y;
                    curZ += lineVec.z;
                    for (int z = minX; z <= maxX; ++z) {
                        areaAdder.accept(BlockPos.containing((double)z, (double)curY, (double)curZ));
                    }
                }
                break;
            }
            case Y: {
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), 0.0, (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x, lineVec.y / 10.0, lineVec.z / 10.0);
                double curX = (double)p1.getX() + 0.5;
                double curZ = (double)p1.getZ() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getZ() - p2.getZ(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.x;
                    curZ += lineVec.z;
                    for (int y = minY; y <= maxY; ++y) {
                        areaAdder.accept(BlockPos.containing((double)curX, (double)y, (double)curZ));
                    }
                }
                break;
            }
            case Z: {
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), 0.0).normalize();
                lineVec = new Vec3(lineVec.x / 10.0, lineVec.y / 10.0, lineVec.z);
                double curX = (double)p1.getX() + 0.5;
                double curY = (double)p1.getY() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getY() - p2.getY(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.x;
                    curY += lineVec.y;
                    for (int z = minZ; z <= maxZ; ++z) {
                        areaAdder.accept(BlockPos.containing((double)curX, (double)curY, (double)z));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.EnumSelectorField<AreaType.AreaAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.AreaAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void convertFromLegacy(EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_WALL: {
                this.axis = AreaType.AreaAxis.X;
                break;
            }
            case Y_WALL: {
                this.axis = AreaType.AreaAxis.Y;
                break;
            }
            case Z_WALL: {
                this.axis = AreaType.AreaAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypeWall that = (AreaTypeWall)o;
        return this.axis == that.axis;
    }

    public int hashCode() {
        return Objects.hashCode(this.axis);
    }
}

